/*
 * Decompiled with CFR 0.152.
 */
package br.ufsc.bridge.platform.validation.rules;

import br.ufsc.bridge.platform.validation.engine.Rule;
import br.ufsc.bridge.platform.validation.util.Util;
import java.util.regex.Pattern;

public class CpfRule
implements Rule<String> {
    private static Pattern PATTERN_GENERIC = Pattern.compile("[0-9]{3}?[0-9]{3}?[0-9]{3}?[0-9]{2}");
    private static Pattern PATTERN_NUMBERS = Pattern.compile("(?=^((?!((([0]{11})|([1]{11})|([2]{11})|([3]{11})|([4]{11})|([5]{11})|([6]{11})|([7]{11})|([8]{11})|([9]{11})))).)*$)([0-9]{11})");

    @Override
    public String validate(String value) {
        if (!Util.isEmpty(value)) {
            if (!CpfRule.isValid(value)) {
                return "CPF inv\u00e1lido";
            }
        }
        return null;
    }

    public static boolean isValid(String cpf) {
        if (cpf != null && PATTERN_GENERIC.matcher(cpf).matches() && (cpf = cpf.replaceAll("-|\\.", "")) != null && PATTERN_NUMBERS.matcher(cpf).matches()) {
            int i;
            int[] numbers = new int[11];
            for (i = 0; i < 11; ++i) {
                numbers[i] = Character.getNumericValue(cpf.charAt(i));
            }
            int sum = 0;
            int factor = 100;
            for (i = 0; i < 9; ++i) {
                sum += numbers[i] * factor;
                factor -= 10;
            }
            int leftover = sum % 11;
            int n = leftover = leftover == 10 ? 0 : leftover;
            if (leftover == numbers[9]) {
                sum = 0;
                factor = 110;
                for (i = 0; i < 10; ++i) {
                    sum += numbers[i] * factor;
                    factor -= 10;
                }
                leftover = sum % 11;
                leftover = leftover == 10 ? 0 : leftover;
                return leftover == numbers[10];
            }
        }
        return false;
    }
}

