/*
 * Decompiled with CFR 0.152.
 */
package br.ufsc.bridge.metafy.processor.type;

import br.ufsc.bridge.metafy.Metafy;
import br.ufsc.bridge.metafy.processor.clazz.MetafyClassContext;
import br.ufsc.bridge.metafy.processor.type.ArrayAttribute;
import br.ufsc.bridge.metafy.processor.type.Attribute;
import br.ufsc.bridge.metafy.processor.type.ListAttribute;
import br.ufsc.bridge.metafy.processor.type.MetaReferenceAttribute;
import br.ufsc.bridge.metafy.processor.type.PrimitiveAttribute;
import br.ufsc.bridge.metafy.processor.type.SetAttribute;
import br.ufsc.bridge.metafy.processor.type.SimpleAttribute;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor6;

public class AttributeVisitor
extends SimpleTypeVisitor6<Attribute, MetafyClassContext> {
    @Override
    public Attribute visitPrimitive(PrimitiveType t, MetafyClassContext p) {
        return new PrimitiveAttribute(p.getActualElement());
    }

    @Override
    public Attribute visitArray(ArrayType t, MetafyClassContext p) {
        return new ArrayAttribute(t, p.getActualElement());
    }

    @Override
    public Attribute visitDeclared(DeclaredType t, MetafyClassContext p) {
        if (this.isList(t.toString())) {
            return new ListAttribute(t, p.getActualElement());
        }
        if (!this.isMap(t.toString())) {
            if (this.isSet(t.toString())) {
                return new SetAttribute(t, p.getActualElement());
            }
            if (t.asElement().getAnnotation(Metafy.class) != null) {
                return new MetaReferenceAttribute(t, p, p.getActualElement());
            }
            return new SimpleAttribute(t, p.getActualElement());
        }
        return (Attribute)super.visitDeclared(t, p);
    }

    private boolean isList(String qualifiedName) {
        return qualifiedName.startsWith("java.util.List");
    }

    private boolean isMap(String qualifiedName) {
        return qualifiedName.startsWith("java.util.Map");
    }

    private boolean isSet(String qualifiedName) {
        return qualifiedName.startsWith("java.util.Set");
    }

    @Override
    public Attribute visitTypeVariable(TypeVariable t, MetafyClassContext p) {
        TypeMirror typeMirror = p.getTypeFor((TypeParameterElement)t.asElement());
        if (typeMirror != null) {
            return new SimpleAttribute((DeclaredType)typeMirror, p.getActualElement());
        }
        return (Attribute)super.visitTypeVariable(t, p);
    }
}

