/*
 * Decompiled with CFR 0.152.
 */
package br.ufsc.bridge.metafy.processor.clazz;

import br.ufsc.bridge.metafy.MetaBean;
import br.ufsc.bridge.metafy.processor.clazz.MetafyClass;
import br.ufsc.bridge.metafy.processor.clazz.MetafyClassContext;
import br.ufsc.bridge.metafy.processor.clazz.MetafyStaticClass;
import br.ufsc.bridge.metafy.processor.type.Attribute;
import br.ufsc.bridge.metafy.processor.type.AttributeVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class MetafyClassFactory {
    private MetafyClassFactory() {
    }

    public static MetafyClass create(TypeElement typeElement) {
        return MetafyClassFactory.create(typeElement, new MetafyClassContext());
    }

    public static MetafyClass create(TypeElement typeElement, MetafyClassContext context) {
        return MetafyClassFactory.create(typeElement.getQualifiedName().toString(), typeElement, context);
    }

    public static MetafyClass create(String name, TypeElement typeElement, MetafyClassContext context) {
        MetafyClass data = typeElement.getModifiers().contains((Object)Modifier.STATIC) ? new MetafyStaticClass(name, typeElement.getQualifiedName().toString()) : new MetafyClass(name, typeElement.getQualifiedName().toString());
        data.importType(MetaBean.class.getName());
        data.importType(typeElement.getQualifiedName().toString());
        context.setClazz(data);
        MetafyClassFactory.visitAttributes(typeElement, data, context);
        return data;
    }

    private static void visitAttributes(TypeElement typeElement, MetafyClass data, MetafyClassContext context) {
        for (VariableElement e : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            context.setActualElement(e);
            Attribute classAttribute = e.asType().accept(new AttributeVisitor(), context);
            if (classAttribute == null) continue;
            data.addAttribute(classAttribute);
        }
    }
}

