/*
 * Decompiled with CFR 0.152.
 */
package br.ufsc.bridge.metafy.processor;

import br.ufsc.bridge.metafy.Metafy;
import br.ufsc.bridge.metafy.processor.clazz.MetafyClass;
import br.ufsc.bridge.metafy.processor.clazz.MetafyClassFactory;
import br.ufsc.bridge.metafy.processor.clazz.MetafyClassSerializer;
import br.ufsc.bridge.metafy.processor.exception.UnexpectedException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"br.ufsc.bridge.metafy.Metafy"})
public class MetafyProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Metafy.class)) {
            if (element.getKind() != ElementKind.CLASS || !((TypeElement)element).getTypeParameters().isEmpty()) continue;
            try {
                MetafyClass data = MetafyClassFactory.create((TypeElement)element);
                this.writeClass(data);
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                throw new UnexpectedException(e);
            }
        }
        return false;
    }

    private void writeClass(MetafyClass data) throws IOException {
        JavaFileObject javaFile = this.processingEnv.getFiler().createSourceFile(data.getCompleteName(), new Element[0]);
        OutputStream os = javaFile.openOutputStream();
        PrintWriter pw = new PrintWriter(os);
        new MetafyClassSerializer().serialize(this.processingEnv, data, pw);
    }
}

