/*
 * Decompiled with CFR 0.152.
 */
package br.ufsc.bridge.metafy.processor;

import br.ufsc.bridge.metafy.FakeTypeElement;
import br.ufsc.bridge.metafy.MetaBean;
import br.ufsc.bridge.metafy.Metafy;
import br.ufsc.bridge.metafy.processor.MetafyClass;
import br.ufsc.bridge.metafy.processor.MetafyClassSerializer;
import br.ufsc.bridge.metafy.processor.MetafyStaticClass;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"br.ufsc.bridge.metafy.Metafy"})
public class MetafyProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Metafy.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            TypeElement typeElement = (TypeElement)element;
            try {
                MetafyClass data = element.getModifiers().contains((Object)Modifier.STATIC) ? new MetafyStaticClass(typeElement.getQualifiedName().toString()) : new MetafyClass(typeElement.getQualifiedName().toString());
                data.importType(MetaBean.class.getName());
                data.importType(typeElement.getQualifiedName().toString());
                for (VariableElement e : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                    if (e.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    data.addFakeType(new FakeTypeElement(this.processingEnv, e));
                }
                new MetafyClassSerializer().serialize(this.processingEnv, data);
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }
}

