package br.ufrgs.cpd.coresdk.ui

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.view.View
import android.view.inputmethod.EditorInfo
import android.view.inputmethod.InputMethodManager
import android.widget.Button
import android.widget.EditText
import android.widget.LinearLayout
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityOptionsCompat
import br.ufrgs.cpd.coresdk.R
import br.ufrgs.cpd.coresdk.data.models.UfrgsToken
import br.ufrgs.cpd.coresdk.token.OnTokenListener
import br.ufrgs.cpd.coresdk.token.UfrgsTokenManager
import com.google.android.material.textfield.TextInputLayout
import org.jetbrains.anko.find
import org.jetbrains.anko.toast


/**
 * Created by theolm on 14/10/16.
 */

class LoginDialog : AppCompatActivity() {

    //    private var mUfrgsTokenManager = UfrgsTokenManager()
//    private var mProgressDialog: ProgressDialog? = null
    private val loginBackground by lazy { find<LinearLayout>(R.id.login_background) }
    private val loginButton by lazy { find<Button>(R.id.login_button) }
    private val loginCard by lazy { find<EditText>(R.id.et_login_card) }
    private val loginPassword by lazy { find<EditText>(R.id.et_login_password) }
    private val loginLayoutCard by lazy { find<TextInputLayout>(R.id.login_layout_card) }
    private val loginLayoutPassword by lazy { find<TextInputLayout>(R.id.login_layout_password) }
    private val loginForgotPasswordTextView by lazy { find<TextView>(R.id.login_forgot_password_text_view) }
    private val loginErrorMessage by lazy { find<TextView>(R.id.login_error_message) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.login_dialog)


//        LayoutUtils.setStatusBarColor(this, "#7d2623")

        // Loading dialog
//        mProgressDialog = ProgressDialog(this)
//        mProgressDialog!!.setMessage(getString(R.string.loading))
//        mProgressDialog!!.setCancelable(false)

        loginBackground.setOnClickListener { onBackPressed() }

        loginButton.setOnClickListener {
            val imm = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
            imm.hideSoftInputFromWindow(loginLayoutPassword.windowToken, 0)

            val u = loginCard.text.toString().isEmpty()
            val p = loginPassword.text.toString().isEmpty()

            if (u) {
                loginLayoutCard.isErrorEnabled = true
                loginLayoutCard.error = getString(R.string.user_needed)
            } else {
                loginLayoutCard.isErrorEnabled = false
                loginLayoutCard.error = ""
            }

            if (p) {
                loginLayoutPassword.isErrorEnabled = true
                loginLayoutPassword.error = getString(R.string.password_needed)
            } else {
                loginLayoutPassword.isErrorEnabled = false
                loginLayoutPassword.error = ""
            }

            if (!u && !p)
                getTokenFromAPI(loginCard.text.toString(), loginPassword.text.toString())
        }

        loginPassword.setOnEditorActionListener(TextView.OnEditorActionListener { v, actionId, event ->
            if (actionId == EditorInfo.IME_ACTION_DONE) {
                loginButton.performClick()
                return@OnEditorActionListener true
            }
            false
        })

        loginForgotPasswordTextView.setOnClickListener {
            val browserIntent = Intent(Intent.ACTION_VIEW, Uri.parse(FORGOT_PASSWORD_URL))
            startActivity(browserIntent)
        }

    }

    override fun onBackPressed() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            this.supportFinishAfterTransition()
        } else {
            this.finish()
        }
    }

    private fun getTokenFromAPI(user: String, password: String) {
        UfrgsTokenManager().requestNewToken(this, user, password, object : OnTokenListener {
            override fun onTokenReady(token: UfrgsToken) {
                val bundle = Bundle()
                bundle.putParcelable(TOKEN, token)
                val intent = Intent()
                intent.putExtras(bundle)
                setResult(Activity.RESULT_OK, intent)
                finish()
            }

            override fun onError(error: String) {
                loginErrorMessage.visibility = View.GONE
                loginErrorMessage.setText(R.string.wrong_user_or_password)
                loginErrorMessage.visibility = View.VISIBLE

                toast(error)
            }

        })

    }

    companion object {
        private val FORGOT_PASSWORD_URL = "https://www1.ufrgs.br/trocasenhas/esqueciSenha/"
        const val TOKEN = "token"
        const val LOGIN_REQUEST_CODE = 13

        fun start(activity: Activity, animateView: View) {
            val i = Intent(activity, LoginDialog::class.java)

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                val options = ActivityOptionsCompat.makeSceneTransitionAnimation(activity, animateView, activity.getString(R.string.shared_element_name_login_button))
                activity.startActivityForResult(i, LOGIN_REQUEST_CODE, options.toBundle())
            } else {
                activity.startActivityForResult(i, LOGIN_REQUEST_CODE)
            }
        }

        fun start(activity: Activity) {
            val i = Intent(activity, LoginDialog::class.java)
            activity.startActivityForResult(i, LOGIN_REQUEST_CODE)
        }


    }

}
