package br.ufrgs.cpd.coresdk.network

import okhttp3.ResponseBody
import br.ufrgs.cpd.coresdk.network.models.ApiAnswer
import br.ufrgs.cpd.coresdk.network.models.LogoutData
import br.ufrgs.cpd.coresdk.network.models.TokenData
import kotlinx.coroutines.Deferred
import retrofit2.http.*


interface ApiInterface {
    @FormUrlEncoded
    @POST("v1/token")
    fun getToken(@Field("client_id") client_id: String,
                 @Field("client_secret") client_secret: String,
                 @Field("grant_type") grant_type: String,
                 @Field("username") username: String,
                 @Field("password") password: String,
                 @Field("scope") scope: String): Deferred<ApiAnswer<TokenData>>

    @FormUrlEncoded
    @POST("v1/logout")
    fun logoutFromAPI(@Header("Authorization") authorizationHeader: String,
                      @Field("deviceID") deviceId: String): Deferred<ResponseBody>

    @FormUrlEncoded
    @PUT("v1/dispositivo")
    fun registerGcmDevice(@Header("Authorization") authorizationHeader: String,
                          @Field("iid") gcmToken: String,
                          @Field("deviceID") deviceUID: String): Deferred<ApiAnswer<LogoutData>>
}