package br.ufrgs.cpd.coresdk.network

import br.ufrgs.cpd.coresdk.BuildConfig
import br.ufrgs.cpd.coresdk.UfrgsSdk
import com.jakewharton.retrofit2.adapter.kotlin.coroutines.CoroutineCallAdapterFactory
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit

object ApiBuilder {

    private fun getClient(): OkHttpClient {
        val interceptor = HttpLoggingInterceptor()

        interceptor.level = if (BuildConfig.DEBUG) HttpLoggingInterceptor.Level.BODY else HttpLoggingInterceptor.Level.NONE
        return OkHttpClient.Builder()
                .addInterceptor(interceptor)
                .readTimeout(60, TimeUnit.SECONDS)
                .connectTimeout(60, TimeUnit.SECONDS)
                .build()
    }

    fun retrofit(): Retrofit {
        return Retrofit.Builder()
                .baseUrl(UfrgsSdk.baseUrl)
                .addCallAdapterFactory(CoroutineCallAdapterFactory())
                .client(getClient())
                .addConverterFactory(GsonConverterFactory.create())
                .build()
    }
}