package br.ufrgs.cpd.coresdk.data.models

import android.os.Parcelable
import br.ufrgs.cpd.coresdk.network.models.TokenData
import kotlinx.android.parcel.Parcelize
import java.util.*

@Parcelize
data class UfrgsToken(
        val accessToken: String,
        val refreshToken: String,
        val tokenType: String,
        val expiresAt: Long
) : Parcelable {
    companion object {
        fun newInstance(tokenData: TokenData): UfrgsToken {
            val expiresAt = (tokenData.expires_in + (Date().time / 1000)) * 1000

            return UfrgsToken(
                    tokenData.access_token,
                    tokenData.refresh_token,
                    tokenData.token_type,
                    expiresAt
            )
        }
    }
}