package br.ufrgs.cpd.coresdk.data

import android.content.Context
import br.ufrgs.cpd.coresdk.data.models.UfrgsToken
import com.google.gson.Gson
import org.jetbrains.anko.defaultSharedPreferences
import java.util.*

class UfrgsDataManager {
    internal fun saveToken(context: Context, token: UfrgsToken) {
        val serializedToken = Gson().toJson(token)

        context.defaultSharedPreferences.edit()
                .putString(KEY_TOKEN, serializedToken)
                .apply()
    }

    internal fun getToken(context: Context): UfrgsToken? {
        validateToken(context)

        val serializedToken = context.defaultSharedPreferences.getString(KEY_TOKEN, null)
                ?: return null
        return Gson().fromJson<UfrgsToken>(serializedToken, UfrgsToken::class.java)
    }

    internal fun deleteToken(context: Context) {
        context.defaultSharedPreferences.edit()
                .remove(KEY_TOKEN)
                .apply()
    }

    private fun validateToken(context: Context) {
        val serializedToken = context.defaultSharedPreferences.getString(KEY_TOKEN, null)
        val token = Gson().fromJson<UfrgsToken>(serializedToken, UfrgsToken::class.java)

        if (token != null) {
            if (token.expiresAt <= Date().time) {
                deleteToken(context)
            }
        }
    }

    companion object {
        private const val KEY_TOKEN = "token"
    }
}