package br.ufrgs.cpd.coresdk

import android.content.Context
import android.content.pm.PackageManager

object UfrgsSdk {
    internal lateinit var baseUrl: String
    internal lateinit var clientId: String
    internal lateinit var clientSecret: String
    internal lateinit var scope: String
    internal lateinit var grantType: String

    private const val BASE_URL_DEV = "https://api.dev.ufrgs.br/"
    private const val BASE_URL_PROD = "https://api.ufrgs.br/"

    fun initialize(context: Context, setApiToProduction: Boolean) {

        val app = context.packageManager.getApplicationInfo(context.packageName, PackageManager.GET_META_DATA)
        val bundle = app.metaData
        clientId = bundle.getString("br.ufrgs.sdk.clientid") ?: ""
        clientSecret = bundle.getString("br.ufrgs.sdk.clientsecret") ?: ""
        scope = bundle.getString("br.ufrgs.sdk.scope") ?: ""
        grantType = bundle.getString("br.ufrgs.sdk.granttype") ?: "password"

        baseUrl = if (setApiToProduction) BASE_URL_PROD else BASE_URL_DEV

    }
}
