/*
 * Decompiled with CFR 0.152.
 */
package hugedataaccess.structures;

import hugedataaccess.DataAccess;
import hugedataaccess.MMapDataAccess;
import hugedataaccess.structures.MMapMap;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class MMapTreeMap
implements MMapMap {
    private static final int NODE_SIZE = 64;
    private DataAccess treeAccess;
    private long pos = 0L;
    private long root = -1L;

    public MMapTreeMap(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        File f = new File(path);
        boolean exists = true;
        if (!f.exists()) {
            f.mkdirs();
            exists = false;
        }
        try {
            this.treeAccess = new MMapDataAccess(path + "treeMap.mmap", 0x2000000L);
            if (exists) {
                this.pos = this.treeAccess.getLong(0L);
                this.root = this.treeAccess.getLong(8L);
            } else {
                this.treeAccess.setLong(0L, 0L);
                this.treeAccess.setLong(8L, -1L);
                this.pos = 0L;
                this.root = -1L;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Long size() {
        return this.treeAccess.getLong(0L);
    }

    @Override
    public boolean containsKey(Long key) {
        return this.get(key) != null;
    }

    @Override
    public Long get(Long key) {
        long node = this.root;
        while (node != -1L) {
            long nodeKey = this.getKey(node);
            if (nodeKey == key) {
                return this.getValue(node);
            }
            if (key < nodeKey) {
                node = this.getLeft(node);
                continue;
            }
            node = this.getRight(node);
        }
        return null;
    }

    @Override
    public void put(Long key, Long value) {
        if ((this.size() + 1L) * 64L > this.treeAccess.getCapacity()) {
            this.treeAccess.ensureCapacity(this.treeAccess.getCapacity() + 0x2000000L);
        }
        if (this.root == -1L) {
            this.root = this.pos++;
            this.setKey(this.root, key);
            this.setValue(this.root, value);
            this.setLeft(this.root, -1L);
            this.setRight(this.root, -1L);
            this.setParent(this.root, -1L);
            this.setBalanceFactor(this.root, 0);
            this.treeAccess.setLong(0L, this.treeAccess.getLong(0L) + 1L);
            this.treeAccess.setLong(8L, this.root);
        } else {
            long child;
            long parent = child = this.root;
            boolean isLeft = true;
            while (child != -1L) {
                parent = child;
                if (this.getKey(parent) == key.longValue()) {
                    this.setValue(parent, value);
                    return;
                }
                if (key < this.getKey(parent)) {
                    child = this.getLeft(parent);
                    isLeft = true;
                    continue;
                }
                child = this.getRight(parent);
                isLeft = false;
            }
            this.setKey(this.pos, key);
            this.setValue(this.pos, value);
            this.setLeft(this.pos, -1L);
            this.setRight(this.pos, -1L);
            this.setParent(this.pos, parent);
            this.setBalanceFactor(this.pos, 0);
            this.treeAccess.setLong(0L, this.treeAccess.getLong(0L) + 1L);
            if (isLeft) {
                this.setLeft(parent, this.pos);
            } else {
                this.setRight(parent, this.pos);
            }
            this.balanceTree(this.pos);
            ++this.pos;
        }
    }

    private void balanceTree(long Z) {
        long N = -1L;
        long X = this.getParent(Z);
        while (X != -1L) {
            block8: {
                long G;
                block7: {
                    block9: {
                        block5: {
                            block6: {
                                if (Z != this.getRight(X)) break block5;
                                if (this.getBalanceFactor(X) <= 0) break block6;
                                G = this.getParent(X);
                                N = this.getBalanceFactor(Z) < 0 ? this.rotateRightLeft(X, Z) : this.rotateLeft(X, Z);
                                break block7;
                            }
                            if (this.getBalanceFactor(X) < 0) {
                                this.setBalanceFactor(X, 0);
                                break;
                            }
                            this.setBalanceFactor(X, 1);
                            Z = X;
                            break block8;
                        }
                        if (this.getBalanceFactor(X) >= 0) break block9;
                        G = this.getParent(X);
                        N = this.getBalanceFactor(Z) > 0 ? this.rotateLeftRight(X, Z) : this.rotateRight(X, Z);
                        break block7;
                    }
                    if (this.getBalanceFactor(X) > 0) {
                        this.setBalanceFactor(X, 0);
                        break;
                    }
                    this.setBalanceFactor(X, -1);
                    Z = X;
                    break block8;
                }
                this.setParent(N, G);
                if (G != -1L) {
                    if (X == this.getLeft(G)) {
                        this.setLeft(G, N);
                        break;
                    }
                    this.setRight(G, N);
                    break;
                }
                this.root = N;
                this.treeAccess.setLong(8L, this.root);
                break;
            }
            X = this.getParent(Z);
        }
    }

    private long rotateLeft(long X, long Z) {
        long t23 = this.getLeft(Z);
        this.setRight(X, t23);
        if (t23 != -1L) {
            this.setParent(t23, X);
        }
        this.setLeft(Z, X);
        this.setParent(X, Z);
        if (this.getBalanceFactor(Z) == 0) {
            this.setBalanceFactor(X, 1);
            this.setBalanceFactor(Z, -1);
        } else {
            this.setBalanceFactor(X, 0);
            this.setBalanceFactor(Z, 0);
        }
        return Z;
    }

    private long rotateRightLeft(long X, long Z) {
        long Y = this.getLeft(Z);
        long t3 = this.getRight(Y);
        this.setLeft(Z, t3);
        if (t3 != -1L) {
            this.setParent(t3, Z);
        }
        this.setRight(Y, Z);
        this.setParent(Z, Y);
        long t2 = this.getLeft(Y);
        this.setRight(X, t2);
        if (t2 != -1L) {
            this.setParent(t2, X);
        }
        this.setLeft(Y, X);
        this.setParent(X, Y);
        int yBalance = this.getBalanceFactor(Y);
        if (yBalance > 0) {
            this.setBalanceFactor(X, -1);
            this.setBalanceFactor(Z, 0);
        } else if (yBalance == 0) {
            this.setBalanceFactor(X, 0);
            this.setBalanceFactor(Z, 0);
        } else {
            this.setBalanceFactor(X, 0);
            this.setBalanceFactor(Z, 1);
        }
        this.setBalanceFactor(Y, 0);
        return Y;
    }

    private long rotateRight(long X, long Z) {
        long t23 = this.getRight(Z);
        this.setLeft(X, t23);
        if (t23 != -1L) {
            this.setParent(t23, X);
        }
        this.setRight(Z, X);
        this.setParent(X, Z);
        if (this.getBalanceFactor(Z) == 0) {
            this.setBalanceFactor(X, -1);
            this.setBalanceFactor(Z, 1);
        } else {
            this.setBalanceFactor(X, 0);
            this.setBalanceFactor(Z, 0);
        }
        return Z;
    }

    private long rotateLeftRight(long X, long Z) {
        long Y = this.getRight(Z);
        long t3 = this.getLeft(Y);
        this.setRight(Z, t3);
        if (t3 != -1L) {
            this.setParent(t3, Z);
        }
        this.setLeft(Y, Z);
        this.setParent(Z, Y);
        long t2 = this.getRight(Y);
        this.setLeft(X, t2);
        if (t2 != -1L) {
            this.setParent(t2, X);
        }
        this.setRight(Y, X);
        this.setParent(X, Y);
        int yBalance = this.getBalanceFactor(Y);
        if (yBalance < 0) {
            this.setBalanceFactor(X, 1);
            this.setBalanceFactor(Z, 0);
        } else if (yBalance == 0) {
            this.setBalanceFactor(X, 0);
            this.setBalanceFactor(Z, 0);
        } else {
            this.setBalanceFactor(X, 0);
            this.setBalanceFactor(Z, -1);
        }
        this.setBalanceFactor(Y, 0);
        return Y;
    }

    @Override
    public Iterable<Long> keySet() {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    private long i = 0L;

                    @Override
                    public boolean hasNext() {
                        return this.i < MMapTreeMap.this.size();
                    }

                    @Override
                    public Long next() {
                        return MMapTreeMap.this.getKey(this.i++);
                    }
                };
            }
        };
    }

    private long getIndex(long pos) {
        return 16L + pos * 64L;
    }

    private long getKey(long pos) {
        return this.treeAccess.getLong(this.getIndex(pos));
    }

    private long getValue(long pos) {
        return this.treeAccess.getLong(this.getIndex(pos) + 8L);
    }

    private long getLeft(long pos) {
        return this.treeAccess.getLong(this.getIndex(pos) + 16L);
    }

    private long getRight(long pos) {
        return this.treeAccess.getLong(this.getIndex(pos) + 24L);
    }

    private long getParent(long pos) {
        return this.treeAccess.getLong(this.getIndex(pos) + 32L);
    }

    private int getBalanceFactor(long pos) {
        if (pos == -1L) {
            return 0;
        }
        return this.treeAccess.getInt(this.getIndex(pos) + 40L);
    }

    private void setKey(long pos, long key) {
        this.treeAccess.setLong(this.getIndex(pos), key);
    }

    private void setValue(long pos, long value) {
        this.treeAccess.setLong(this.getIndex(pos) + 8L, value);
    }

    private void setLeft(long pos, long left) {
        this.treeAccess.setLong(this.getIndex(pos) + 16L, left);
    }

    private void setRight(long pos, long right) {
        this.treeAccess.setLong(this.getIndex(pos) + 24L, right);
    }

    private void setParent(long pos, long parent) {
        this.treeAccess.setLong(this.getIndex(pos) + 32L, parent);
    }

    private void setBalanceFactor(long pos, int balanceFactor) {
        this.treeAccess.setInt(this.getIndex(pos) + 40L, balanceFactor);
    }

    @Override
    public void printOrder(Long pos) {
        if (pos != -1L) {
            this.printOrder(this.getLeft(pos));
            System.out.print(this.getKey(pos) + " | ");
            this.printOrder(this.getRight(pos));
        }
    }
}

