/*
 * Decompiled with CFR 0.152.
 */
package hugedataaccess;

import hugedataaccess.ByteBufferDataAccess;
import hugedataaccess.DataAccessException;
import hugedataaccess.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MMapDataAccess
extends ByteBufferDataAccess {
    private RandomAccessFile randomAccessFile;
    private boolean isNewFile;

    public MMapDataAccess(String fileName) {
        this(fileName, 0x100000);
    }

    public MMapDataAccess(String fileName, int bufferSize) {
        File f = new File(fileName);
        this.isNewFile = !f.exists();
        try {
            this.setSegmentSize(bufferSize);
            this.randomAccessFile = new RandomAccessFile(fileName, "rw");
        }
        catch (IOException e) {
            throw new DataAccessException(e.getMessage(), e);
        }
    }

    public MMapDataAccess(String fileName, long bytesCapacity) throws IOException {
        this(fileName, bytesCapacity, 0x100000);
    }

    public MMapDataAccess(String fileName, long bytesCapacity, int bufferSize) throws IOException {
        this(fileName, bufferSize);
        try {
            this.ensureCapacity(bytesCapacity);
        }
        catch (DataAccessException e) {
            if (this.isNewFile) {
                this.randomAccessFile.close();
                FileUtils.delete(fileName);
            }
            throw e;
        }
    }

    private void validateCapacity(long numberOfBytes) {
        if (numberOfBytes / (long)this.segmentSize >= Integer.MAX_VALUE) {
            throw new DataAccessException("Buffer size is too small to fit in the given capacity.");
        }
        if (numberOfBytes % (long)this.segmentSize != 0L) {
            throw new DataAccessException("Capacity must be a multiple of buffer size.");
        }
    }

    @Override
    public void ensureCapacity(long bytes) {
        long numberOfBytes = bytes;
        long startPos = -1L;
        int segment = -1;
        try {
            int currentNumberOfBuffers;
            if (this.getCapacity() > numberOfBytes) {
                numberOfBytes = this.getCapacity();
            }
            this.validateCapacity(numberOfBytes);
            int expectedNumberOfBuffers = (int)Math.ceil(1.0 * (double)numberOfBytes / (double)this.segmentSize);
            int n = currentNumberOfBuffers = this.buffers == null ? 0 : this.buffers.length;
            if (expectedNumberOfBuffers > currentNumberOfBuffers) {
                ByteBuffer[] newBuffers = new ByteBuffer[expectedNumberOfBuffers];
                if (this.buffers != null) {
                    for (int i = 0; i < currentNumberOfBuffers; ++i) {
                        newBuffers[i] = this.buffers[i];
                    }
                }
                for (segment = currentNumberOfBuffers; segment < expectedNumberOfBuffers; ++segment) {
                    startPos = (long)segment * (long)this.segmentSize;
                    newBuffers[segment] = this.randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, startPos, this.segmentSize);
                }
                this.buffers = newBuffers;
            }
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder();
            msg.append("\nnumberOfBytes (capacity): ").append(numberOfBytes);
            msg.append("\nbufferSize: ").append(this.segmentSize);
            msg.append("\nstartPos: ").append(startPos);
            msg.append("\nsegment#: ").append(segment);
            msg.append("\n").append(e.getMessage());
            throw new DataAccessException(msg.toString(), e);
        }
    }

    @Override
    public long getCapacity() {
        try {
            return this.randomAccessFile.length();
        }
        catch (IOException e) {
            throw new DataAccessException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.randomAccessFile == null || this.getCapacity() == 0L;
    }

    @Override
    public void close() {
        try {
            if (this.buffers != null) {
                for (ByteBuffer buffer : this.buffers) {
                    buffer.clear();
                }
                this.buffers = null;
            }
            System.gc();
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
        }
        catch (IOException e) {
            throw new DataAccessException(e.getMessage(), e);
        }
    }
}

