/*
 * Decompiled with CFR 0.152.
 */
package hugedataaccess;

import hugedataaccess.BaseDataAccess;
import hugedataaccess.DataAccessException;
import java.nio.ByteBuffer;

public class ByteBufferDataAccess
extends BaseDataAccess {
    protected ByteBuffer[] buffers;

    public ByteBufferDataAccess() {
        this(0x100000);
    }

    public ByteBufferDataAccess(int bufferSize) {
        this.setSegmentSize(bufferSize);
    }

    @Override
    public void ensureCapacity(long bytes) {
        int currentNumberOfBuffers;
        long numberOfBytes = bytes;
        if (this.getCapacity() > numberOfBytes) {
            numberOfBytes = this.getCapacity();
        }
        if (numberOfBytes % (long)this.segmentSize != 0L) {
            throw new DataAccessException("Capacity must be a multiple of segment size.");
        }
        int expectedNumberOfBuffers = (int)Math.ceil(1.0 * (double)numberOfBytes / (double)this.segmentSize);
        int n = currentNumberOfBuffers = this.buffers == null ? 0 : this.buffers.length;
        if (expectedNumberOfBuffers > currentNumberOfBuffers) {
            int i;
            ByteBuffer[] newBuffers = new ByteBuffer[expectedNumberOfBuffers];
            if (this.buffers != null) {
                for (i = 0; i < currentNumberOfBuffers; ++i) {
                    newBuffers[i] = this.buffers[i];
                }
            }
            for (i = currentNumberOfBuffers; i < expectedNumberOfBuffers; ++i) {
                newBuffers[i] = ByteBuffer.allocate(this.segmentSize);
            }
            this.buffers = newBuffers;
        }
    }

    @Override
    public long getCapacity() {
        return this.buffers == null ? 0L : (long)(this.buffers.length * this.segmentSize);
    }

    @Override
    public byte getByte(long bytePos) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.buffers[segmentIndex].get(segmentPos);
    }

    @Override
    public void setByte(long bytePos, byte element) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.buffers[segmentIndex].put(segmentPos, element);
    }

    @Override
    public char getChar(long bytePos) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.buffers[segmentIndex].getChar(segmentPos);
    }

    @Override
    public void setChar(long bytePos, char element) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.buffers[segmentIndex].putChar(segmentPos, element);
    }

    @Override
    public short getShort(long bytePos) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.buffers[segmentIndex].getShort(segmentPos);
    }

    @Override
    public void setShort(long bytePos, short element) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.buffers[segmentIndex].putShort(segmentPos, element);
    }

    @Override
    public int getInt(long bytePos) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.buffers[segmentIndex].getInt(segmentPos);
    }

    @Override
    public void setInt(long bytePos, int element) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.buffers[segmentIndex].putInt(segmentPos, element);
    }

    @Override
    public long getLong(long bytePos) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.buffers[segmentIndex].getLong(segmentPos);
    }

    @Override
    public void setLong(long bytePos, long element) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.buffers[segmentIndex].putLong(segmentPos, element);
    }

    @Override
    public float getFloat(long bytePos) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.buffers[segmentIndex].getFloat(segmentPos);
    }

    @Override
    public void setFloat(long bytePos, float element) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.buffers[segmentIndex].putFloat(segmentPos, element);
    }

    @Override
    public double getDouble(long bytePos) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.buffers[segmentIndex].getDouble(segmentPos);
    }

    @Override
    public void setDouble(long bytePos, double element) {
        int segmentIndex = (int)(bytePos >> this.segmentSizePower);
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.buffers[segmentIndex].putDouble(segmentPos, element);
    }

    @Override
    public void close() {
        if (this.buffers != null) {
            for (ByteBuffer buffer : this.buffers) {
                buffer.clear();
            }
            this.buffers = null;
        }
    }
}

