/*
 * Decompiled with CFR 0.152.
 */
package hugedataaccess;

import hugedataaccess.BaseDataAccess;
import hugedataaccess.DataAccessException;
import hugedataaccess.util.ByteUtils;

public class ByteArrayDataAccess
extends BaseDataAccess {
    private byte[][] segments;

    public ByteArrayDataAccess() {
        this(0x100000);
    }

    public ByteArrayDataAccess(int segmentSize) {
        this.setSegmentSize(segmentSize);
    }

    @Override
    public long getCapacity() {
        return this.segments == null ? 0L : (long)(this.segments.length * this.segmentSize);
    }

    @Override
    public void ensureCapacity(long bytes) {
        int currentNumberOfSegments;
        if (bytes % (long)this.segmentSize != 0L) {
            throw new DataAccessException("Capacity must be a multiple of segment size.");
        }
        int expectedNumberOfSegments = (int)Math.ceil(1.0 * (double)bytes / (double)this.segmentSize);
        int n = currentNumberOfSegments = this.segments == null ? 0 : this.segments.length;
        if (expectedNumberOfSegments > currentNumberOfSegments) {
            int i;
            byte[][] newSegments = new byte[expectedNumberOfSegments][];
            if (this.segments != null) {
                for (i = 0; i < currentNumberOfSegments; ++i) {
                    newSegments[i] = this.segments[i];
                }
            }
            for (i = currentNumberOfSegments; i < expectedNumberOfSegments; ++i) {
                newSegments[i] = new byte[this.segmentSize];
            }
            this.segments = newSegments;
        }
    }

    @Override
    public byte getByte(long bytePos) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return this.segments[segmentIndex][segmentPos];
    }

    @Override
    public void setByte(long bytePos, byte element) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        this.segments[segmentIndex][segmentPos] = element;
    }

    @Override
    public char getChar(long bytePos) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return ByteUtils.getChar(this.segments[segmentIndex], segmentPos);
    }

    @Override
    public void setChar(long bytePos, char element) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        ByteUtils.setChar(this.segments[segmentIndex], element, segmentPos);
    }

    @Override
    public short getShort(long bytePos) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return ByteUtils.getShort(this.segments[segmentIndex], segmentPos);
    }

    @Override
    public void setShort(long bytePos, short element) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        ByteUtils.setShort(this.segments[segmentIndex], element, segmentPos);
    }

    @Override
    public int getInt(long bytePos) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return ByteUtils.getInt(this.segments[segmentIndex], segmentPos);
    }

    @Override
    public void setInt(long bytePos, int element) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        ByteUtils.setInt(this.segments[segmentIndex], element, segmentPos);
    }

    @Override
    public long getLong(long bytePos) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return ByteUtils.getLong(this.segments[segmentIndex], segmentPos);
    }

    @Override
    public void setLong(long bytePos, long element) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        ByteUtils.setLong(this.segments[segmentIndex], element, segmentPos);
    }

    @Override
    public float getFloat(long bytePos) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return ByteUtils.getFloat(this.segments[segmentIndex], segmentPos);
    }

    @Override
    public void setFloat(long bytePos, float element) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        ByteUtils.setFloat(this.segments[segmentIndex], element, segmentPos);
    }

    @Override
    public double getDouble(long bytePos) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        return ByteUtils.getDouble(this.segments[segmentIndex], segmentPos);
    }

    @Override
    public void setDouble(long bytePos, double element) {
        int segmentIndex = (int)bytePos >> this.segmentSizePower;
        int segmentPos = (int)(bytePos & (long)this.segmentSizeDivisor);
        ByteUtils.setDouble(this.segments[segmentIndex], element, segmentPos);
    }

    @Override
    public void close() {
        this.segments = null;
    }
}

