/*
 * Decompiled with CFR 0.152.
 */
package hugedataaccess;

import hugedataaccess.DataAccess;
import hugedataaccess.DataAccessException;

public abstract class BaseDataAccess
implements DataAccess {
    protected long currentPosition;
    protected int segmentSize;
    protected int segmentSizePower;
    protected int segmentSizeDivisor;
    public static final int DEFAULT_SEGMENT_SIZE = 0x100000;

    @Override
    public boolean isEmpty() {
        return this.getCapacity() == 0L;
    }

    @Override
    public byte getByte() {
        return this.getByte(this.currentPosition++);
    }

    @Override
    public void setByte(byte element) {
        this.setByte(this.currentPosition++, element);
    }

    @Override
    public char getChar() {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 2) {
            this.currentPosition += (long)segmentRemainder;
        }
        return this.getChar((this.currentPosition += 2L) - 2L);
    }

    @Override
    public void setChar(char element) {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 2) {
            this.currentPosition += (long)segmentRemainder;
        }
        this.setChar(this.currentPosition, element);
        this.currentPosition += 2L;
    }

    @Override
    public short getShort() {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 2) {
            this.currentPosition += (long)segmentRemainder;
        }
        return this.getShort((this.currentPosition += 2L) - 2L);
    }

    @Override
    public void setShort(short element) {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 2) {
            this.currentPosition += (long)segmentRemainder;
        }
        this.setShort(this.currentPosition, element);
        this.currentPosition += 2L;
    }

    @Override
    public int getInt() {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 4) {
            this.currentPosition += (long)segmentRemainder;
        }
        return this.getInt((this.currentPosition += 4L) - 4L);
    }

    @Override
    public void setInt(int element) {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 4) {
            this.currentPosition += (long)segmentRemainder;
        }
        this.setInt(this.currentPosition, element);
        this.currentPosition += 4L;
    }

    @Override
    public long getLong() {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 8) {
            this.currentPosition += (long)segmentRemainder;
        }
        return this.getLong((this.currentPosition += 8L) - 8L);
    }

    @Override
    public void setLong(long element) {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 8) {
            this.currentPosition += (long)segmentRemainder;
        }
        this.setLong(this.currentPosition, element);
        this.currentPosition += 8L;
    }

    @Override
    public float getFloat() {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 4) {
            this.currentPosition += (long)segmentRemainder;
        }
        return this.getFloat((this.currentPosition += 4L) - 4L);
    }

    @Override
    public void setFloat(float element) {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 4) {
            this.currentPosition += (long)segmentRemainder;
        }
        this.setFloat(this.currentPosition, element);
        this.currentPosition += 4L;
    }

    @Override
    public double getDouble() {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 4) {
            this.currentPosition += (long)segmentRemainder;
        }
        return this.getDouble((this.currentPosition += 8L) - 8L);
    }

    @Override
    public void setDouble(double element) {
        int segmentRemainder = this.segmentSize - (int)this.currentPosition & this.segmentSizeDivisor;
        if (segmentRemainder < 4) {
            this.currentPosition += (long)segmentRemainder;
        }
        this.setDouble(this.currentPosition, element);
        this.currentPosition += 8L;
    }

    @Override
    public long getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public void setCurrentPosition(long currentPosition) {
        this.currentPosition = currentPosition;
    }

    protected void setSegmentSize(int segmentSize) {
        this.segmentSize = segmentSize;
        this.segmentSizePower = (int)(Math.log(segmentSize) / Math.log(2.0));
        if (Math.pow(2.0, this.segmentSizePower) != (double)segmentSize) {
            throw new DataAccessException("segmentSize must be a power of 2.");
        }
        this.segmentSizeDivisor = segmentSize - 1;
    }
}

