/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.structure;

import br.ufc.insightlab.graphast.model.Edge;
import br.ufc.insightlab.graphast.model.Node;
import br.ufc.insightlab.graphast.model.components.GraphComponent;
import br.ufc.insightlab.graphast.structure.GraphStructure;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.insightlab.hugedataaccess.DataAccess;
import org.insightlab.hugedataaccess.MMapDataAccess;
import org.insightlab.hugedataaccess.structures.MMapMap;
import org.insightlab.hugedataaccess.structures.MMapTreeMap;

public class MMapGraphStructure
implements GraphStructure {
    private static final int NODE_SIZE = 32;
    private static final int EDGE_SIZE = 64;
    private static final long INITIAL_NODE_FILE_SIZE = 0x800000L;
    private static final long INITIAL_EDGE_FILE_SIZE = 0x800000L;
    private long nodePos = 0L;
    private long edgePos = 0L;
    private MMapMap nodIdMapping;
    private MMapMap edgeIdMapping;
    private String nodesFile = "nodes.mmap";
    private String edgesFile = "edges.mmap";
    private DataAccess nodeAccess;
    private DataAccess edgeAccess;

    public MMapGraphStructure(String path) {
        String directory = path;
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        this.nodIdMapping = new MMapTreeMap(directory);
        File f = new File(directory);
        boolean graphExists = f.exists();
        if (!graphExists) {
            f.mkdirs();
        }
        try {
            this.nodeAccess = new MMapDataAccess(directory + this.nodesFile, 0x800000L);
            this.edgeAccess = new MMapDataAccess(directory + this.edgesFile, 0x800000L);
            if (graphExists) {
                this.nodePos = this.getNumberOfNodes();
                this.edgePos = this.getNumberOfEdges();
                for (long i = 0L; i < this.nodePos; ++i) {
                    this.nodIdMapping.put(Long.valueOf(this.nodeAccess.getLong(this.getNodeIndex(i))), Long.valueOf(i));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long getNodeIndex(long id) {
        return 8L + id * 32L;
    }

    private long getEdgeIndex(long id) {
        return 8L + id * 64L;
    }

    private long getExternalIdByInternalId(long internalId) {
        return this.nodeAccess.getLong(this.getNodeIndex(internalId));
    }

    private void addDirectionalEdge(Edge e) {
        if (this.edgeAccess.getCapacity() < this.getEdgeIndex(this.edgePos) + 64L) {
            this.edgeAccess.ensureCapacity(this.edgeAccess.getCapacity() + 0x800000L);
        }
        long fromId = this.nodIdMapping.get(Long.valueOf(e.getFromNodeId()));
        long toId = this.nodIdMapping.get(Long.valueOf(e.getToNodeId()));
        long fromIndex = this.getNodeIndex(fromId);
        long toIndex = this.getNodeIndex(toId);
        long edgeIndex = this.getEdgeIndex(this.edgePos);
        this.edgeAccess.setLong(edgeIndex, fromId);
        this.edgeAccess.setLong(edgeIndex + 8L, toId);
        this.edgeAccess.setDouble(edgeIndex + 16L, e.getWeight());
        this.edgeAccess.setLong(edgeIndex + 24L, this.nodeAccess.getLong(fromIndex + 8L));
        this.edgeAccess.setLong(edgeIndex + 32L, this.nodeAccess.getLong(toIndex + 16L));
        this.nodeAccess.setLong(fromIndex + 8L, this.edgePos);
        this.nodeAccess.setLong(toIndex + 16L, this.edgePos);
        this.edgeAccess.setLong(0L, ++this.edgePos);
    }

    @Override
    public long nodeIndex(long nodeId) {
        return 0L;
    }

    @Override
    public long edgeIndex(long edgeId) {
        return 0L;
    }

    @Override
    public void addNode(Node n) {
        if (this.nodeAccess.getCapacity() < this.getNodeIndex(this.nodePos) + 32L) {
            this.nodeAccess.ensureCapacity(this.nodeAccess.getCapacity() + 0x800000L);
        }
        this.nodIdMapping.put(Long.valueOf(n.getId()), Long.valueOf(this.nodePos));
        long nodeIndex = this.getNodeIndex(this.nodePos);
        this.nodeAccess.setLong(nodeIndex, n.getId());
        this.nodeAccess.setLong(nodeIndex + 8L, -1L);
        this.nodeAccess.setLong(nodeIndex + 16L, -1L);
        this.nodeAccess.setLong(0L, ++this.nodePos);
    }

    @Override
    public void addEdge(Edge e) {
        this.addDirectionalEdge(e);
        if (e.isBidirectional()) {
            this.addDirectionalEdge(new Edge(e.getToNodeId(), e.getFromNodeId(), e.getWeight()));
        }
    }

    @Override
    public Node getNode(long id) {
        return new Node(id);
    }

    @Override
    public Node removeNode(Node n) {
        return null;
    }

    @Override
    public boolean isRemoved(Node n) {
        return false;
    }

    @Override
    public Edge getEdge(long id) {
        return null;
    }

    @Override
    public Edge removeEdge(Edge e) {
        return null;
    }

    @Override
    public boolean isRemoved(Edge e) {
        return false;
    }

    @Override
    public void updateAdjacency(Edge e) {
    }

    @Override
    public boolean containsNode(long id) {
        return this.nodIdMapping.containsKey(Long.valueOf(id));
    }

    @Override
    public boolean containsEdge(long id) {
        return this.edgeIdMapping.containsKey(Long.valueOf(id));
    }

    @Override
    public Iterator<Node> allNodesIterator() {
        return new Iterator<Node>(){
            long id = 0L;

            @Override
            public boolean hasNext() {
                return this.id < MMapGraphStructure.this.getNumberOfNodes();
            }

            @Override
            public Node next() {
                return new Node(MMapGraphStructure.this.getExternalIdByInternalId(this.id++));
            }

            @Override
            public void remove() {
                Iterator.super.remove();
            }
        };
    }

    @Override
    public Iterator<Edge> allEdgesIterator() {
        return new Iterator<Edge>(){
            long pos = 0L;

            @Override
            public boolean hasNext() {
                return this.pos < MMapGraphStructure.this.getNumberOfEdges();
            }

            @Override
            public Edge next() {
                long edgeIndex = MMapGraphStructure.this.getEdgeIndex(this.pos);
                long from = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex);
                long to = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex + 8L);
                double cost = MMapGraphStructure.this.edgeAccess.getDouble(edgeIndex + 16L);
                ++this.pos;
                return new Edge(MMapGraphStructure.this.getExternalIdByInternalId(from), MMapGraphStructure.this.getExternalIdByInternalId(to), cost);
            }

            @Override
            public void remove() {
                Iterator.super.remove();
            }
        };
    }

    @Override
    public long getNumberOfNodes() {
        return this.nodeAccess.getLong(0L);
    }

    @Override
    public long getNumberOfEdges() {
        return this.edgeAccess.getLong(0L);
    }

    @Override
    public Iterator<Edge> getAllOutEdgesIterator(final long id) {
        return new Iterator<Edge>(){
            long pos;
            {
                this.pos = MMapGraphStructure.this.nodeAccess.getLong(MMapGraphStructure.this.getNodeIndex(MMapGraphStructure.this.nodIdMapping.get(Long.valueOf(id))) + 8L);
            }

            @Override
            public boolean hasNext() {
                return this.pos != -1L;
            }

            @Override
            public Edge next() {
                long edgeIndex = MMapGraphStructure.this.getEdgeIndex(this.pos);
                long from = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex);
                long to = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex + 8L);
                double cost = MMapGraphStructure.this.edgeAccess.getDouble(edgeIndex + 16L);
                this.pos = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex + 24L);
                return new Edge(MMapGraphStructure.this.getExternalIdByInternalId(from), MMapGraphStructure.this.getExternalIdByInternalId(to), cost);
            }

            @Override
            public void remove() {
                Iterator.super.remove();
            }
        };
    }

    @Override
    public Iterator<Edge> getAllInEdgesIterator(final long id) {
        return new Iterator<Edge>(){
            long pos;
            {
                this.pos = MMapGraphStructure.this.nodeAccess.getLong(MMapGraphStructure.this.getNodeIndex(MMapGraphStructure.this.nodIdMapping.get(Long.valueOf(id))) + 16L);
            }

            @Override
            public boolean hasNext() {
                return this.pos != -1L;
            }

            @Override
            public Edge next() {
                long edgeIndex = MMapGraphStructure.this.getEdgeIndex(this.pos);
                long from = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex);
                long to = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex + 8L);
                double cost = MMapGraphStructure.this.edgeAccess.getDouble(edgeIndex + 16L);
                this.pos = MMapGraphStructure.this.edgeAccess.getLong(edgeIndex + 32L);
                return new Edge(MMapGraphStructure.this.getExternalIdByInternalId(from), MMapGraphStructure.this.getExternalIdByInternalId(to), cost);
            }

            @Override
            public void remove() {
                Iterator.super.remove();
            }
        };
    }

    @Override
    public Set<Class<? extends GraphComponent>> getAllComponentClasses() {
        return null;
    }

    @Override
    public GraphComponent getComponent(Class<? extends GraphComponent> componentClass) {
        return null;
    }

    @Override
    public void addComponent(Class<? extends GraphComponent> key, GraphComponent component) {
    }

    @Override
    public Iterator<GraphComponent> getAllComponentsIterator() {
        return null;
    }
}

