/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.structure;

import br.ufc.insightlab.graphast.model.Edge;
import br.ufc.insightlab.graphast.model.Node;
import br.ufc.insightlab.graphast.model.components.GraphComponent;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;

public interface GraphStructure {
    public long nodeIndex(long var1);

    public long edgeIndex(long var1);

    public void addNode(Node var1);

    public Node getNode(long var1);

    public Node removeNode(Node var1);

    default public Node removeNode(long id) {
        return this.removeNode(this.getNode(id));
    }

    public boolean isRemoved(Node var1);

    public void addEdge(Edge var1);

    public Edge getEdge(long var1);

    default public Edge getEdge(long from, long to) {
        if (!this.containsNode(from) || !this.containsNode(to)) {
            return null;
        }
        for (Edge out : this.getOutEdges(from)) {
            if (out.getAdjacent(from) != to) continue;
            return out;
        }
        return null;
    }

    public Edge removeEdge(Edge var1);

    default public Edge removeEdge(long id) {
        return this.removeEdge(this.getEdge(id));
    }

    default public Edge removeEdge(long fromId, long toId) {
        return this.removeEdge(this.getEdge(fromId, toId));
    }

    public boolean isRemoved(Edge var1);

    public void updateAdjacency(Edge var1);

    public boolean containsNode(long var1);

    public boolean containsEdge(long var1);

    public Iterator<Node> allNodesIterator();

    @Nonnull
    default public Iterator<Node> existingNodesIterator() {
        return Iterators.filter(this.allNodesIterator(), n -> !this.isRemoved((Node)n));
    }

    default public Iterable<Node> getNodes() {
        return this::existingNodesIterator;
    }

    public Iterator<Edge> allEdgesIterator();

    @Nonnull
    default public Iterator<Edge> existingEdgesIterator() {
        return Iterators.filter(this.allEdgesIterator(), e -> !this.isRemoved((Edge)e));
    }

    default public Iterable<Edge> getEdges() {
        return this::existingEdgesIterator;
    }

    public long getNumberOfNodes();

    public long getNumberOfEdges();

    public Iterator<Edge> getAllOutEdgesIterator(long var1);

    default public Iterator<Edge> getExistingOutEdgesIterator(long id) {
        return Iterators.filter(this.getAllOutEdgesIterator(id), e -> !this.isRemoved((Edge)e));
    }

    default public Iterable<Edge> getOutEdges(long id) {
        return () -> this.getExistingOutEdgesIterator(id);
    }

    public Iterator<Edge> getAllInEdgesIterator(long var1);

    default public Iterator<Edge> getExistingInEdgesIterator(long id) {
        return Iterators.filter(this.getAllInEdgesIterator(id), e -> !this.isRemoved((Edge)e));
    }

    default public Iterable<Edge> getInEdges(long id) {
        return () -> this.getExistingInEdgesIterator(id);
    }

    public Set<Class<? extends GraphComponent>> getAllComponentClasses();

    public GraphComponent getComponent(Class<? extends GraphComponent> var1);

    public void addComponent(Class<? extends GraphComponent> var1, GraphComponent var2);

    default public void addComponent(GraphComponent component) {
        this.addComponent(component.getClass(), component);
    }

    @Nonnull
    public Iterator<GraphComponent> getAllComponentsIterator();

    default public Iterable<GraphComponent> getAllComponents() {
        return this::getAllComponentsIterator;
    }
}

