/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.structure;

import br.ufc.insightlab.graphast.exceptions.DuplicatedEdgeException;
import br.ufc.insightlab.graphast.exceptions.DuplicatedNodeException;
import br.ufc.insightlab.graphast.exceptions.NodeNotFoundException;
import br.ufc.insightlab.graphast.model.Edge;
import br.ufc.insightlab.graphast.model.Node;
import br.ufc.insightlab.graphast.model.components.GraphComponent;
import br.ufc.insightlab.graphast.structure.GraphStructure;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.LongIntMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultGraphStructure
implements GraphStructure {
    private static final int OUT_EDGES = 0;
    private static final int IN_EDGES = 1;
    private Map<Class<? extends GraphComponent>, GraphComponent> graphComponents = null;
    private int nextNodeId = 0;
    private int nextEdgeId = 0;
    private LongIntMap nodeIdMapping = new LongIntHashMap();
    private LongIntMap edgeIdMapping = new LongIntHashMap();
    private IntArrayList aliveNodes = new IntArrayList();
    private IntArrayList aliveEdges = new IntArrayList();
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<Edge> edges = new ArrayList();
    private int numberOfNodes = 0;
    private int numberOfEdges = 0;
    private ArrayList<IntSet[]> adjacency = new ArrayList();

    @Override
    public void updateAdjacency(Edge e) {
        this.updateAdjacency(e, this.edgeIdMapping.get(e.getId()));
    }

    private void updateAdjacency(Edge e, int eIndex) {
        int fromIndex = this.nodeIdMapping.get(e.getFromNodeId());
        int toIndex = this.nodeIdMapping.get(e.getToNodeId());
        IntSet[] fromAdj = this.adjacency.get(fromIndex);
        IntSet[] toAdj = this.adjacency.get(toIndex);
        fromAdj[0].add(eIndex);
        toAdj[1].add(eIndex);
        if (e.isBidirectional()) {
            fromAdj[1].add(eIndex);
            toAdj[0].add(eIndex);
        } else {
            fromAdj[1].removeAll(eIndex);
            toAdj[0].removeAll(eIndex);
        }
    }

    @Override
    public long nodeIndex(long nodeId) {
        return this.nodeIdMapping.get(nodeId);
    }

    @Override
    public long edgeIndex(long edgeId) {
        return this.edgeIdMapping.get(edgeId);
    }

    @Override
    public void addNode(Node node) {
        long nId = node.getId();
        if (this.containsNode(nId)) {
            throw new DuplicatedNodeException(nId);
        }
        int index = this.nextNodeId++;
        this.nodeIdMapping.put(nId, index);
        int aliveIndex = index >> 5;
        int aliveSubIndex = index & 0x1F;
        if (aliveIndex >= this.aliveNodes.size()) {
            this.aliveNodes.add(0);
        }
        this.aliveNodes.set(aliveIndex, this.aliveNodes.get(aliveIndex) | (byte)(1 << aliveSubIndex));
        this.adjacency.add((IntSet[])new IntHashSet[]{new IntHashSet(), new IntHashSet()});
        this.nodes.add(node);
        ++this.numberOfNodes;
    }

    @Override
    public void addEdge(Edge e) {
        if (!this.containsNode(e.getFromNodeId())) {
            throw new NodeNotFoundException(e.getFromNodeId());
        }
        if (!this.containsNode(e.getToNodeId())) {
            throw new NodeNotFoundException(e.getToNodeId());
        }
        if (this.containsEdge(e.getId())) {
            throw new DuplicatedEdgeException(e.getId());
        }
        int eIndex = this.nextEdgeId++;
        this.edgeIdMapping.put(e.getId(), eIndex);
        int aliveIndex = eIndex >> 5;
        int aliveSubIndex = eIndex & 0x1F;
        if (aliveIndex >= this.aliveEdges.size()) {
            this.aliveEdges.add(0);
        }
        this.aliveEdges.set(aliveIndex, this.aliveEdges.get(aliveIndex) | 1 << aliveSubIndex);
        this.updateAdjacency(e, eIndex);
        this.edges.add(e);
        ++this.numberOfEdges;
    }

    @Override
    public boolean containsNode(long id) {
        return this.nodeIdMapping.containsKey(id) && !this.isRemoved(this.nodes.get(this.nodeIdMapping.get(id)));
    }

    @Override
    public boolean containsEdge(long id) {
        return this.edgeIdMapping.containsKey(id) && !this.isRemoved(this.edges.get(this.edgeIdMapping.get(id)));
    }

    @Override
    public Iterator<Node> allNodesIterator() {
        return this.nodes.iterator();
    }

    @Override
    public Iterator<Edge> allEdgesIterator() {
        return this.edges.iterator();
    }

    @Override
    public long getNumberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public long getNumberOfEdges() {
        return this.numberOfEdges;
    }

    @Override
    public Node getNode(long id) {
        return this.nodes.get(this.nodeIdMapping.get(id));
    }

    @Override
    public Node removeNode(Node n) {
        int index = this.nodeIdMapping.get(n.getId());
        int aliveIndex = index >> 5;
        int aliveSubIndex = index & 0x1F;
        this.aliveNodes.set(aliveIndex, this.aliveNodes.get(aliveIndex) & ~(1 << aliveSubIndex));
        for (Edge e : this.getOutEdges(n.getId())) {
            this.removeEdge(e);
        }
        for (Edge e : this.getInEdges(n.getId())) {
            this.removeEdge(e);
        }
        --this.numberOfNodes;
        return n;
    }

    @Override
    public boolean isRemoved(Node n) {
        int index = this.nodeIdMapping.get(n.getId());
        int aliveIndex = index >> 5;
        int aliveSubIndex = index & 0x1F;
        return (this.aliveNodes.get(aliveIndex) & 1 << aliveSubIndex) == 0;
    }

    @Override
    public Edge getEdge(long id) {
        return this.edges.get(this.edgeIdMapping.get(id));
    }

    @Override
    public Edge removeEdge(Edge e) {
        int index = this.edgeIdMapping.get(e.getId());
        int aliveIndex = index >> 5;
        int aliveSubIndex = index & 0x1F;
        this.aliveEdges.set(aliveIndex, this.aliveEdges.get(aliveIndex) & ~(1 << aliveSubIndex));
        --this.numberOfEdges;
        return e;
    }

    @Override
    public boolean isRemoved(Edge e) {
        int index = this.edgeIdMapping.get(e.getId());
        int aliveIndex = index >> 5;
        int aliveSubIndex = index & 0x1F;
        return (this.aliveEdges.get(aliveIndex) & 1 << aliveSubIndex) == 0;
    }

    private Iterator<Edge> getAdjacencyIterator(final long id, final int outOrIn) {
        return new Iterator<Edge>(){
            private Iterator<IntCursor> iter;
            {
                this.iter = ((IntSet[])DefaultGraphStructure.this.adjacency.get(DefaultGraphStructure.this.nodeIdMapping.get(id)))[outOrIn].iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Edge next() {
                return (Edge)DefaultGraphStructure.this.edges.get(this.iter.next().value);
            }
        };
    }

    @Override
    public Iterator<Edge> getAllOutEdgesIterator(long id) {
        return this.getAdjacencyIterator(id, 0);
    }

    @Override
    public Iterator<Edge> getAllInEdgesIterator(long id) {
        return this.getAdjacencyIterator(id, 1);
    }

    @Override
    public void addComponent(Class<? extends GraphComponent> key, GraphComponent component) {
        if (this.graphComponents == null) {
            this.graphComponents = new HashMap<Class<? extends GraphComponent>, GraphComponent>();
        }
        this.graphComponents.put(key, component);
    }

    @Override
    public GraphComponent getComponent(Class<? extends GraphComponent> componentClass) {
        if (this.graphComponents == null || !this.graphComponents.containsKey(componentClass)) {
            return null;
        }
        return this.graphComponents.get(componentClass);
    }

    @Override
    public Set<Class<? extends GraphComponent>> getAllComponentClasses() {
        if (this.graphComponents == null) {
            return null;
        }
        return this.graphComponents.keySet();
    }

    @Override
    @Nonnull
    public Iterator<GraphComponent> getAllComponentsIterator() {
        return this.graphComponents != null ? this.graphComponents.values().iterator() : new Iterator<GraphComponent>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public GraphComponent next() {
                return null;
            }
        };
    }
}

