/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.serialization;

import java.io.File;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static String ensureDirectory(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    public static boolean deleteMMapGraph(String path) {
        String directory = SerializationUtils.ensureDirectory(path);
        File f = new File(directory);
        boolean ok = true;
        if (f.exists()) {
            ok = new File(directory + "nodes.mmap").delete();
            ok = new File(directory + "edges.mmap").delete() && ok;
            ok = new File(directory + "treeMap.mmap").delete() && ok;
            ok = f.delete() && ok;
        }
        return ok;
    }

    public static boolean deleteSerializedGraph(String path) {
        String directory = SerializationUtils.ensureDirectory(path);
        File f = new File(directory);
        boolean ok = true;
        if (f.exists()) {
            ok = new File(directory + "nodes.phast").delete();
            ok = new File(directory + "edges.phast").delete() && ok;
            ok = new File(directory + "graph_components.phast").delete() && ok;
            ok = f.delete() && ok;
        }
        return ok;
    }
}

