/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.serialization;

import br.ufc.insightlab.graphast.model.Edge;
import br.ufc.insightlab.graphast.model.Graph;
import br.ufc.insightlab.graphast.model.Node;
import br.ufc.insightlab.graphast.model.components.GraphComponent;
import br.ufc.insightlab.graphast.serialization.GraphSerializer;
import br.ufc.insightlab.graphast.serialization.SerializationUtils;
import br.ufc.insightlab.graphast.structure.GraphStructure;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class KryoSerializer
extends GraphSerializer {
    private static GraphSerializer instance = null;
    private Kryo kryo = new Kryo();

    private KryoSerializer() {
        this.kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
    }

    public static GraphSerializer getInstance() {
        if (instance == null) {
            instance = new KryoSerializer();
        }
        return instance;
    }

    @Override
    public Graph load(String path, GraphStructure structure) throws FileNotFoundException {
        long startTime = System.currentTimeMillis();
        Graph g = new Graph(structure);
        String directory = SerializationUtils.ensureDirectory(path);
        File f = new File(directory);
        boolean graphExists = f.exists();
        if (!graphExists) {
            f.mkdirs();
        }
        try {
            Input in = new Input((InputStream)new FileInputStream(directory + "nodes.phast"));
            while (!in.eof()) {
                g.addNode((Node)this.kryo.readObject(in, Node.class));
            }
            in.close();
            in = new Input((InputStream)new FileInputStream(directory + "edges.phast"));
            while (!in.eof()) {
                g.addEdge((Edge)this.kryo.readObject(in, Edge.class));
            }
            in.close();
            in = new Input((InputStream)new FileInputStream(directory + "graph_components.phast"));
            while (!in.eof()) {
                g.addComponent((GraphComponent)this.kryo.readObject(in, GraphComponent.class));
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long totalTime = System.currentTimeMillis() - startTime;
        System.out.println("Time to load using kryo: " + (double)totalTime / 1000.0 + " s");
        return g;
    }

    @Override
    public void save(String path, Graph graph) {
        String directory = SerializationUtils.ensureDirectory(path);
        File f = new File(directory);
        boolean graphExists = f.exists();
        if (!graphExists) {
            f.mkdirs();
        }
        try {
            Output out = new Output((OutputStream)new FileOutputStream(directory + "nodes.phast"));
            for (Node n : graph.getNodes()) {
                this.kryo.writeObject(out, (Object)n);
            }
            out.close();
            out = new Output((OutputStream)new FileOutputStream(directory + "edges.phast"));
            for (Edge e : graph.getEdges()) {
                this.kryo.writeObject(out, (Object)e);
            }
            out.close();
            out = new Output((OutputStream)new FileOutputStream(directory + "graph_components.phast"));
            for (GraphComponent component : graph.getAllComponents()) {
                this.kryo.writeObject(out, (Object)component);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

