/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.query.utils;

import br.ufc.insightlab.graphast.query.utils.DistanceElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DistanceVector {
    private long sourceId;
    private HashMap<Long, DistanceElement> vector;

    public DistanceVector(long sourceId) {
        this.sourceId = sourceId;
        this.vector = new HashMap();
        DistanceElement first = new DistanceElement(sourceId);
        first.changeDistance(0.0);
        this.vector.put(sourceId, first);
    }

    public DistanceElement getElement(long id) {
        if (!this.vector.containsKey(id)) {
            this.vector.put(id, new DistanceElement(id));
        }
        return this.vector.get(id);
    }

    public void printAll() {
        for (Long n : this.vector.keySet()) {
            DistanceElement element = this.vector.get(n);
            System.out.println("Distance to node " + n + ": " + element.getDistance() + " | Previous node: " + element.getParentId());
        }
    }

    public List<Long> getPath(long targetId) {
        if (this.getElement(targetId).getParentId() == -1L) {
            System.out.println("No path between '" + this.sourceId + "' and '" + targetId + "'");
            return null;
        }
        ArrayList<Long> path = new ArrayList<Long>();
        path.add(targetId);
        long parentId = targetId;
        while ((parentId = this.vector.get(parentId).getParentId()) != -1L) {
            path.add(0, parentId);
            if (parentId != this.sourceId) continue;
            break;
        }
        return path;
    }

    public void printPathTo(long targetId) {
        System.out.println(this.getPath(targetId).stream().map(String::valueOf).reduce((s1, s2) -> s1 + " -> " + s2).get());
    }

    public double getDistance(long targetId) {
        return this.vector.get(targetId).getDistance();
    }
}

