/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.query.shortestpath;

import br.ufc.insightlab.graphast.exceptions.NodeNotFoundException;
import br.ufc.insightlab.graphast.model.Edge;
import br.ufc.insightlab.graphast.model.Graph;
import br.ufc.insightlab.graphast.query.cost_functions.CostFunction;
import br.ufc.insightlab.graphast.query.cost_functions.CostFunctionFactory;
import br.ufc.insightlab.graphast.query.shortestpath.ShortestPathStrategy;
import br.ufc.insightlab.graphast.query.utils.DistanceElement;
import br.ufc.insightlab.graphast.query.utils.DistanceVector;
import java.util.PriorityQueue;
import java.util.Queue;

public class DijkstraStrategy
implements ShortestPathStrategy {
    private Graph g;
    private CostFunction costFunction;

    public DijkstraStrategy(Graph g) {
        this.g = g;
        this.costFunction = CostFunctionFactory.getDefaultCostFunction();
    }

    @Override
    public void setCostFunction(CostFunction costFunction) {
        this.costFunction = costFunction;
    }

    @Override
    public DistanceVector run(long sourceId) throws NodeNotFoundException {
        return this.run(sourceId, -1L);
    }

    @Override
    public DistanceVector run(long sourceId, long targetId) throws NodeNotFoundException {
        if (!this.g.containsNode(sourceId)) {
            throw new NodeNotFoundException(sourceId);
        }
        if (targetId != -1L && !this.g.containsNode(targetId)) {
            throw new NodeNotFoundException(targetId);
        }
        DistanceVector vector = new DistanceVector(sourceId);
        PriorityQueue<DistanceElement> toVisit = new PriorityQueue<DistanceElement>();
        toVisit.add(vector.getElement(sourceId));
        while (!toVisit.isEmpty()) {
            DistanceElement min = (DistanceElement)toVisit.poll();
            if (targetId != -1L && targetId == min.getNodeId()) {
                return vector;
            }
            if (min.isVisited()) continue;
            this.visitNode(min, vector, toVisit);
        }
        return vector;
    }

    private void visitNode(DistanceElement node, DistanceVector vector, Queue<DistanceElement> toVisit) {
        node.setVisited(true);
        for (Edge e : this.g.getOutEdges(node.getNodeId())) {
            DistanceElement neighbor = vector.getElement(e.getAdjacent(node.getNodeId()));
            if (neighbor.isVisited()) continue;
            this.relaxPath(e, node, neighbor, toVisit);
        }
    }

    private void relaxPath(Edge e, DistanceElement node, DistanceElement neighbor, Queue<DistanceElement> toVisit) {
        double newDistance;
        try {
            newDistance = node.getDistance() + this.costFunction.getCost(e);
        }
        catch (Exception e1) {
            System.err.println(e1.getMessage() + ", using edge default cost intead.");
            newDistance = e.getWeight();
        }
        if (neighbor.getDistance() > newDistance && !neighbor.isVisited()) {
            neighbor.changeDistance(newDistance);
            neighbor.changePrevious(node.getNodeId());
            toVisit.add(neighbor);
        }
    }
}

