/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.query.cost_functions;

import br.ufc.insightlab.graphast.query.cost_functions.CostFunction;
import br.ufc.insightlab.graphast.query.cost_functions.DefaultCostFunction;
import br.ufc.insightlab.graphast.query.cost_functions.InterpolationMethod;
import br.ufc.insightlab.graphast.query.cost_functions.TimeDependentCostFunction;
import br.ufc.insightlab.graphast.query.cost_functions.TimeDependentLinearCostFunction;
import br.ufc.insightlab.graphast.query.cost_functions.TimeDependentStepCostFunction;
import java.util.Calendar;

public class CostFunctionFactory {
    public static CostFunction getDefaultCostFunction() {
        return new DefaultCostFunction();
    }

    public static CostFunction getTimeDependentCostFunction() {
        return CostFunctionFactory.getTimeDependentCostFunction(InterpolationMethod.LINEAR);
    }

    public static TimeDependentCostFunction getTimeDependentCostFunction(InterpolationMethod interpolationMethod) {
        Calendar now = Calendar.getInstance();
        switch (interpolationMethod) {
            case STEP: {
                return new TimeDependentStepCostFunction(now.get(11), now.get(12));
            }
        }
        return new TimeDependentLinearCostFunction(now.get(11), now.get(12));
    }
}

