/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.model;

import br.ufc.insightlab.graphast.model.GraphObject;
import br.ufc.insightlab.graphast.model.components.NodeComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Node
extends GraphObject {
    private static final long serialVersionUID = -8614831471786755717L;
    private Map<Class<? extends NodeComponent>, NodeComponent> nodeComponents = null;
    private long id;

    public Node() {
    }

    public Node(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void addComponent(NodeComponent component) {
        this.addComponent(component.getClass(), component);
    }

    public void addComponent(Class<? extends NodeComponent> key, NodeComponent component) {
        if (this.nodeComponents == null) {
            this.nodeComponents = new HashMap<Class<? extends NodeComponent>, NodeComponent>();
        }
        this.nodeComponents.put(key, component);
        component.setNode(this);
    }

    public <C extends NodeComponent> C getComponent(Class<C> componentClass) {
        if (this.nodeComponents == null || !this.nodeComponents.containsKey(componentClass)) {
            return null;
        }
        return (C)((NodeComponent)componentClass.cast(this.nodeComponents.get(componentClass)));
    }

    public boolean hasComponent(Class<? extends NodeComponent> key) {
        return this.getComponent(key) != null;
    }

    public Set<Class<? extends NodeComponent>> getAllComponentClasses() {
        return this.nodeComponents.keySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Node)) {
            return false;
        }
        return ((Node)obj).getId() == this.id;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }
}

