/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.model;

import br.ufc.insightlab.graphast.exceptions.DuplicatedNodeException;
import br.ufc.insightlab.graphast.model.Edge;
import br.ufc.insightlab.graphast.model.GraphObject;
import br.ufc.insightlab.graphast.model.Node;
import br.ufc.insightlab.graphast.model.components.GraphComponent;
import br.ufc.insightlab.graphast.model.listeners.EdgeListener;
import br.ufc.insightlab.graphast.model.listeners.NodeListener;
import br.ufc.insightlab.graphast.structure.DefaultGraphStructure;
import br.ufc.insightlab.graphast.structure.GraphStructure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Graph
extends GraphObject {
    private static final long serialVersionUID = -3661942047360629183L;
    private long duplicatedNodesCounter = 0L;
    private GraphStructure structure;
    private List<NodeListener> nodeListeners = new ArrayList<NodeListener>();
    private List<EdgeListener> edgeListeners = new ArrayList<EdgeListener>();

    public Graph() {
        this(new DefaultGraphStructure());
    }

    public Graph(GraphStructure structure) {
        this.structure = structure;
    }

    public void addNodeListener(NodeListener listener) {
        listener.setGraph(this);
        this.nodeListeners.add(listener);
    }

    public void addEdgeListener(EdgeListener listener) {
        listener.setGraph(this);
        this.edgeListeners.add(listener);
    }

    public void addNode(long id) {
        this.addNode(new Node(id));
    }

    public void addNodes(long ... ids) {
        for (long id : ids) {
            this.addNode(id);
        }
    }

    public void addNode(Node n) {
        try {
            this.structure.addNode(n);
            for (NodeListener listener : this.nodeListeners) {
                listener.onInsert(n);
            }
        }
        catch (DuplicatedNodeException e) {
            ++this.duplicatedNodesCounter;
        }
    }

    public Node removeNode(long id) {
        Node n = this.structure.removeNode(id);
        for (NodeListener listener : this.nodeListeners) {
            listener.onRemove(n);
        }
        return n;
    }

    public long getDuplicatedNodesCounter() {
        return this.duplicatedNodesCounter;
    }

    public void addNodes(Node ... nodes) {
        for (Node n : nodes) {
            this.addNode(n);
        }
    }

    public void addEdge(Edge e) {
        this.structure.addEdge(e);
        for (EdgeListener listener : this.edgeListeners) {
            listener.onInsert(e);
        }
    }

    public Edge removeEdge(long id) {
        Edge e = this.structure.removeEdge(id);
        for (EdgeListener listener : this.edgeListeners) {
            listener.onRemove(e);
        }
        return e;
    }

    public Edge removeEdge(long fromId, long toId) {
        Edge e = this.structure.removeEdge(fromId, toId);
        for (EdgeListener listener : this.edgeListeners) {
            listener.onRemove(e);
        }
        return e;
    }

    public void addEdges(Edge ... edges) {
        for (Edge e : edges) {
            this.addEdge(e);
        }
    }

    public void updateAdjacency(Edge e) {
        this.structure.updateAdjacency(e);
    }

    public boolean containsNode(long id) {
        return this.structure.containsNode(id);
    }

    public Node getNode(long id) {
        return this.structure.getNode(id);
    }

    public Iterator<Node> getNodeIterator() {
        return this.structure.existingNodesIterator();
    }

    public Iterable<Node> getNodes() {
        return this.structure.getNodes();
    }

    public Edge getEdge(long id) {
        return this.structure.getEdge(id);
    }

    public Edge getEdge(long from, long to) {
        return this.structure.getEdge(from, to);
    }

    public Iterator<Edge> getEdgeIterator() {
        return this.structure.existingEdgesIterator();
    }

    public Iterable<Edge> getEdges() {
        return this.structure.getEdges();
    }

    public long getNumberOfNodes() {
        return this.structure.getNumberOfNodes();
    }

    public long getNumberOfEdges() {
        return this.structure.getNumberOfEdges();
    }

    public Iterator<Edge> getOutEdgesIterator(long id) {
        return this.structure.getExistingOutEdgesIterator(id);
    }

    public Iterable<Edge> getOutEdges(long id) {
        return this.structure.getOutEdges(id);
    }

    public Iterator<Edge> getInEdgesIterator(long id) {
        return this.structure.getExistingInEdgesIterator(id);
    }

    public Iterable<Edge> getInEdges(long id) {
        return this.structure.getInEdges(id);
    }

    public <C extends GraphComponent> C getComponent(Class<C> componentClass) {
        return (C)((GraphComponent)componentClass.cast(this.structure.getComponent(componentClass)));
    }

    public boolean hasComponent(Class<? extends GraphComponent> key) {
        return this.getComponent(key) != null;
    }

    public void addComponent(GraphComponent component) {
        this.addComponent(component.getClass(), component);
    }

    public void addComponent(Class<? extends GraphComponent> key, GraphComponent component) {
        this.structure.addComponent(key, component);
        component.setGraph(this);
    }

    public Iterable<GraphComponent> getAllComponents() {
        return this.structure.getAllComponents();
    }

    public Set<Class<? extends GraphComponent>> getAllComponentNames() {
        return this.structure.getAllComponentClasses();
    }

    public Iterator<Long> getNeighborhoodIterator(final long id) {
        return new Iterator<Long>(){
            Iterator<Edge> iter;
            {
                this.iter = Graph.this.structure.getExistingOutEdgesIterator(id);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Long next() {
                Edge e = this.iter.next();
                return e.getFromNodeId() == id ? e.getToNodeId() : e.getFromNodeId();
            }
        };
    }

    public Iterable<Long> getNeighborhood(long id) {
        return () -> this.getNeighborhoodIterator(id);
    }
}

