/*
 * Decompiled with CFR 0.152.
 */
package br.ufc.insightlab.graphast.model;

import br.ufc.insightlab.graphast.model.GraphObject;
import br.ufc.insightlab.graphast.model.components.EdgeComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Edge
extends GraphObject {
    private static Integer nextId = 0;
    private static final long serialVersionUID = -3414011816257456570L;
    private Map<Class<? extends EdgeComponent>, EdgeComponent> edgeComponent = null;
    private long id;
    private long fromNodeId;
    private long toNodeId;
    private double weight;
    private boolean bidirectional;

    public Edge() {
        this.weight = 1.0;
        Integer n = nextId;
        Integer n2 = nextId = Integer.valueOf(nextId + 1);
        this.id = n.intValue();
    }

    public Edge(long from, long to) {
        this(from, to, 1.0);
    }

    public Edge(long from, long to, double cost) {
        Integer n = nextId;
        Integer n2 = nextId = Integer.valueOf(nextId + 1);
        this.id = n.intValue();
        this.fromNodeId = from;
        this.toNodeId = to;
        this.weight = cost;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getFromNodeId() {
        return this.fromNodeId;
    }

    public long getToNodeId() {
        return this.toNodeId;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setFromNodeId(long fromNode) {
        this.fromNodeId = fromNode;
    }

    public void setToNodeId(long toNode) {
        this.toNodeId = toNode;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void invert() {
        long aux = this.fromNodeId;
        this.fromNodeId = this.toNodeId;
        this.toNodeId = aux;
    }

    public long getAdjacent(long id) {
        return id == this.toNodeId ? this.fromNodeId : this.toNodeId;
    }

    public void addComponent(EdgeComponent component) {
        this.addComponent(component.getClass(), component);
    }

    public void addComponent(Class<? extends EdgeComponent> key, EdgeComponent component) {
        if (this.edgeComponent == null) {
            this.edgeComponent = new HashMap<Class<? extends EdgeComponent>, EdgeComponent>();
        }
        this.edgeComponent.put(key, component);
        component.setEdge(this);
    }

    public <C extends EdgeComponent> C getComponent(Class<C> componentClass) {
        if (this.edgeComponent == null || !this.edgeComponent.containsKey(componentClass)) {
            return null;
        }
        return (C)((EdgeComponent)componentClass.cast(this.edgeComponent.get(componentClass)));
    }

    public boolean hasComponent(Class<? extends EdgeComponent> key) {
        return this.getComponent(key) != null;
    }

    public Set<Class<? extends EdgeComponent>> getAllComponentClasses() {
        return this.edgeComponent.keySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        boolean okFromNode = this.fromNodeId == other.fromNodeId;
        boolean okToNode = this.toNodeId == other.toNodeId;
        boolean okCost = this.weight == other.weight;
        return okFromNode && okToNode && okCost;
    }

    public int hashCode() {
        return (this.fromNodeId + "|" + this.toNodeId + "|" + this.weight).hashCode();
    }

    public String toString() {
        return this.fromNodeId + "|" + this.toNodeId + "|" + this.weight;
    }
}

