/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.jaxrs.resteasy;

import br.jus.tst.tstunit.jaxrs.JaxRsException;
import br.jus.tst.tstunit.jaxrs.JsonConverterException;
import br.jus.tst.tstunit.jaxrs.JsonToObjectConverter;
import br.jus.tst.tstunit.jaxrs.MockResponse;
import br.jus.tst.tstunit.jaxrs.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.Validate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jboss.resteasy.mock.MockHttpResponse;

public class ResteasyResponse
implements MockResponse {
    private MockHttpResponse httpResponse;
    @Deprecated
    private TypeReference<?> typeReferenceResposta;
    @Deprecated
    private Class<?> tipoObjetoResposta;

    public ResteasyResponse(MockHttpResponse response) {
        this.httpResponse = Objects.requireNonNull(response, "response");
    }

    @Override
    public MockResponse deveRetornarStatusOk() {
        Assertions.assertThat((int)this.httpResponse.getStatus()).isEqualTo(200);
        return this;
    }

    @Override
    public MockResponse deveRetornarStatus(Response.Status status) {
        Assertions.assertThat((int)this.httpResponse.getStatus()).isEqualTo(status.getStatusCode());
        return this;
    }

    @Override
    public MockResponse deveRetornarRespostaDoTipo(MediaType contentType) {
        this.deveRetornarHeader("Content-Type");
        MediaType contentTypeResposta = MediaType.valueOf((String)this.getHeaderValues("Content-Type").get(0).toString());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)contentTypeResposta.isCompatible(contentType)).overridingErrorMessage("O tipo retornado %s n\u00e3o \u00e9 compat\u00edvel com o tipo informado %s", new Object[]{contentTypeResposta, contentType})).isTrue();
        return this;
    }

    @Override
    @Deprecated
    public MockResponse deveRetornarObjetoDoTipo(Class<?> tipo) {
        this.tipoObjetoResposta = Objects.requireNonNull(tipo, "tipo");
        return this;
    }

    @Override
    @Deprecated
    public MockResponse deveRetornarObjetoDoTipo(TypeReference<?> typeReference) {
        this.typeReferenceResposta = Objects.requireNonNull(typeReference, "typeReferenceResposta");
        return this;
    }

    @Override
    public MockResponse naoDeveRetornarConteudo() {
        Assertions.assertThat((String)this.httpResponse.getContentAsString()).isEmpty();
        return this;
    }

    @Override
    public MockResponse deveRetornarHeader(String headerName) {
        Assertions.assertThat(this.getHeaderValues(headerName)).overridingErrorMessage("Header '%s' ausente da resposta", new Object[]{headerName}).isNotEmpty();
        return this;
    }

    @Override
    public MockResponse deveRetornarHeader(String headerName, Object headerValueEsperado) {
        List<Object> headerValues = this.getHeaderValues(headerName);
        Assertions.assertThat(headerValues).overridingErrorMessage("Header '%s' com valor diferente do esperado. Esperava conter '%s', mas obteve: %s", new Object[]{headerName, headerValueEsperado, headerValues}).contains(new Object[]{headerValueEsperado});
        return this;
    }

    private List<Object> getHeaderValues(String headerName) {
        return ListUtils.emptyIfNull((List)((List)this.httpResponse.getOutputHeaders().get((Object)headerName)));
    }

    @Override
    public InputStream getConteudoResposta() {
        return new ByteArrayInputStream(this.httpResponse.getOutput());
    }

    @Override
    public String getConteudoRespostaComoString() {
        return this.httpResponse.getContentAsString();
    }

    @Override
    @Deprecated
    public <T> T getObjetoRespostaUsando(JsonToObjectConverter converter) {
        Objects.requireNonNull(converter, "converter");
        Validate.validState((this.tipoObjetoResposta != null || this.typeReferenceResposta != null ? 1 : 0) != 0, (String)"Tipo de objeto de resposta n\u00e3o definido", (Object[])new Object[0]);
        try {
            return (T)(this.tipoObjetoResposta != null ? converter.jsonToObject(this.httpResponse.getContentAsString(), this.tipoObjetoResposta) : converter.jsonToObject(this.httpResponse.getContentAsString(), this.typeReferenceResposta));
        }
        catch (JsonConverterException exception) {
            throw new JaxRsException("Erro ao obter corpo da resposta como " + this.tipoObjetoResposta, exception);
        }
    }

    @Override
    public Object getImplementacaoSubjacente() {
        return this.httpResponse;
    }
}

