/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.jaxrs.resteasy;

import br.jus.tst.tstunit.jaxrs.HttpMethod;
import br.jus.tst.tstunit.jaxrs.JaxRsException;
import br.jus.tst.tstunit.jaxrs.JsonToObjectConverter;
import br.jus.tst.tstunit.jaxrs.MockRequest;
import br.jus.tst.tstunit.jaxrs.MockResponse;
import br.jus.tst.tstunit.jaxrs.ObjectToJsonFunction;
import br.jus.tst.tstunit.jaxrs.resteasy.ResteasyResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.ClassUtils;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jglue.cdiunit.ContextController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResteasyRequest
implements MockRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResteasyRequest.class);
    protected Dispatcher dispatcher;
    private HttpMethod httpMethod;
    private String uriTemplate;
    private Object[] pathParams;
    private Map<String, Object[]> queryParams;
    private ContextController contextController;
    private Optional<MediaType> mediaTypeOptional;
    private Optional<InputStream> conteudoOptional;

    public ResteasyRequest(HttpMethod httpMethod, Dispatcher dispatcher, String uriTemplate, ContextController contextController) {
        this.httpMethod = Objects.requireNonNull(httpMethod, "httpMethod");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher");
        this.uriTemplate = Objects.requireNonNull(uriTemplate, "uriTemplate");
        this.contextController = Objects.requireNonNull(contextController, "contextController");
        this.queryParams = new HashMap<String, Object[]>();
        this.mediaTypeOptional = Optional.empty();
        this.conteudoOptional = Optional.empty();
    }

    @Override
    public MockRequest pathParams(Object ... params) {
        this.pathParams = Arrays.stream(params).map(this::encodeParam).collect(Collectors.toList()).toArray();
        return this;
    }

    private Object encodeParam(Object param) {
        Object encodedParam;
        try {
            encodedParam = ClassUtils.isPrimitiveWrapper(param.getClass()) ? param : URLEncoder.encode(param.toString(), Charset.defaultCharset().name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException exception) {
            throw new JaxRsException("Erro ao processar par\u00e2metro: " + param, exception);
        }
        return encodedParam;
    }

    @Override
    public MockRequest queryParam(String key, Object ... values) {
        this.queryParams.put(Objects.requireNonNull(key, "key"), Objects.requireNonNull(values, "values"));
        return this;
    }

    @Override
    public MockRequest queryParams(Map<String, Object[]> params) {
        this.queryParams.putAll(Objects.requireNonNull(params, "params"));
        return this;
    }

    @Override
    public MockRequest contentType(MediaType contentType) {
        this.mediaTypeOptional = Optional.ofNullable(contentType);
        return this;
    }

    @Override
    public MockRequest contentType(String contentType) {
        return this.contentType(MediaType.valueOf((String)Objects.requireNonNull(contentType, "contentType")));
    }

    @Override
    @Deprecated
    public MockRequest content(Object conteudo, JsonToObjectConverter converter) {
        this.conteudoOptional = conteudo != null ? Objects.requireNonNull(converter, "converter").objectToJson(conteudo) : Optional.empty();
        return this;
    }

    @Override
    public MockRequest content(Object conteudo, ObjectToJsonFunction converter) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (conteudo != null) {
            try {
                Objects.requireNonNull(converter, "converter").apply((OutputStream)stream, conteudo);
            }
            catch (Exception exception) {
                throw new JaxRsException("Erro ao converter objeto em JSON: " + conteudo, exception);
            }
        }
        this.conteudoOptional = stream.size() > 0 ? Optional.of(new ByteArrayInputStream(stream.toByteArray())) : Optional.empty();
        return this;
    }

    @Override
    public MockRequest content(byte[] conteudo) {
        this.conteudoOptional = conteudo != null ? Optional.of(new ByteArrayInputStream(conteudo)) : Optional.empty();
        return this;
    }

    @Override
    public MockResponse executar() {
        try {
            MockHttpRequest request = (MockHttpRequest)MethodUtils.invokeExactStaticMethod(MockHttpRequest.class, (String)this.httpMethod.name().toLowerCase(), (Object)this.uriFormatada());
            MockHttpResponse response = new MockHttpResponse();
            this.invoke(request, response);
            return new ResteasyResponse(response);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            throw new JaxRsException("Erro ao processar requisi\u00e7\u00e3o", exception);
        }
    }

    protected String uriFormatada() {
        StringBuilder uriBuilder = new StringBuilder(String.format(this.uriTemplate, this.pathParams));
        if (!this.queryParams.isEmpty()) {
            uriBuilder.append('?').append(1).append('=').append(1);
        }
        this.queryParams.forEach((key, values) -> Arrays.stream(values).forEach(value -> uriBuilder.append('&').append((String)key).append('=').append(value)));
        return uriBuilder.toString();
    }

    protected void invoke(MockHttpRequest request, MockHttpResponse response) {
        this.mediaTypeOptional.ifPresent(arg_0 -> ((MockHttpRequest)request).contentType(arg_0));
        this.conteudoOptional.ifPresent(arg_0 -> ((MockHttpRequest)request).content(arg_0));
        this.contextController.openRequest();
        LOGGER.info("{} {}", (Object)this.httpMethod, (Object)this.uriFormatada());
        this.dispatcher.invoke((HttpRequest)request, (HttpResponse)response);
        this.contextController.closeRequest();
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }
}

