/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.jaxrs.resteasy;

import br.jus.tst.tstunit.jaxrs.HttpMethod;
import br.jus.tst.tstunit.jaxrs.JaxRsEngine;
import br.jus.tst.tstunit.jaxrs.JaxRsException;
import br.jus.tst.tstunit.jaxrs.MockRequest;
import br.jus.tst.tstunit.jaxrs.resteasy.Resteasy;
import br.jus.tst.tstunit.jaxrs.resteasy.ResteasyRequest;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.resteasy.cdi.CdiInjectorFactory;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jglue.cdiunit.ContextController;
import org.slf4j.Logger;

@Resteasy
@ApplicationScoped
public class ResteasyEngine
implements JaxRsEngine {
    protected Dispatcher dispatcher;
    @Inject
    private transient Logger logger;
    @Inject
    private transient ContextController contextController;

    @Override
    public MockRequest get(String uriTemplate) {
        this.logger.debug("GET {}", (Object)uriTemplate);
        return new ResteasyRequest(HttpMethod.GET, this.dispatcher, uriTemplate, this.contextController);
    }

    @Override
    public MockRequest post(String uriTemplate) {
        this.logger.debug("POST {}", (Object)uriTemplate);
        return new ResteasyRequest(HttpMethod.POST, this.dispatcher, uriTemplate, this.contextController);
    }

    @Override
    public MockRequest put(String uriTemplate) {
        this.logger.debug("PUT {}", (Object)uriTemplate);
        return new ResteasyRequest(HttpMethod.PUT, this.dispatcher, uriTemplate, this.contextController);
    }

    @Override
    public MockRequest delete(String uriTemplate) {
        this.logger.debug("DELETE {}", (Object)uriTemplate);
        return new ResteasyRequest(HttpMethod.DELETE, this.dispatcher, uriTemplate, this.contextController);
    }

    @Override
    public MockRequest head(String uriTemplate) {
        this.logger.debug("HEAD {}", (Object)uriTemplate);
        return new ResteasyRequest(HttpMethod.HEAD, this.dispatcher, uriTemplate, this.contextController);
    }

    @Override
    public JaxRsEngine registrarRecurso(Object instancia) {
        this.logger.debug("Registrando inst\u00e2ncia de recurso do tipo: {}", instancia.getClass());
        this.dispatcher.getRegistry().addResourceFactory((ResourceFactory)new SingletonResource(instancia));
        return this;
    }

    @Override
    public JaxRsEngine registrarProvider(Class<?> providerClass) {
        this.logger.debug("Registrando class de provider: {}", providerClass);
        this.dispatcher.getProviderFactory().registerProvider(providerClass);
        return this;
    }

    @Override
    public JaxRsEngine registrarProvider(Object provider) {
        this.logger.debug("Registrando inst\u00e2ncia de provider: {}", provider);
        this.dispatcher.getProviderFactory().registerProviderInstance(provider);
        return this;
    }

    @Override
    public <T> JaxRsEngine definirObjetoContexto(Class<T> classe, T instancia) {
        ResteasyProviderFactory.pushContext(classe, instancia);
        return this;
    }

    @Override
    public Object getImplementacaoSubjacente() {
        return this.dispatcher;
    }

    @PostConstruct
    protected void inicializarDispatcher() {
        CdiInjectorFactory injectorFactory;
        ResteasyProviderFactory resteasyProviderFactory = new ResteasyProviderFactory();
        try {
            injectorFactory = (CdiInjectorFactory)CdiInjectorFactory.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            this.logger.debug("Erro ao instanciar CdiInjectorFactory. Ir\u00e1 tentar de outro modo.", (Throwable)exception);
            try {
                injectorFactory = (CdiInjectorFactory)CdiInjectorFactory.class.getConstructor(ResteasyProviderFactory.class).newInstance(resteasyProviderFactory);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception1) {
                throw new JaxRsException("Erro ao inicializar Dispatcher do RestEasy", exception1);
            }
        }
        resteasyProviderFactory.setInjectorFactory((InjectorFactory)injectorFactory);
        this.dispatcher = new SynchronousDispatcher(resteasyProviderFactory);
        ResteasyProviderFactory.setInstance((ResteasyProviderFactory)this.dispatcher.getProviderFactory());
        RegisterBuiltin.register((ResteasyProviderFactory)this.dispatcher.getProviderFactory());
    }
}

