/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.jaxrs.gson;

import br.jus.tst.tstunit.jaxrs.JsonConverterException;
import br.jus.tst.tstunit.jaxrs.JsonToObjectConverter;
import br.jus.tst.tstunit.jaxrs.TypeReference;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

@Deprecated
public class JsonToObjectConverterGson
implements JsonToObjectConverter {
    private Gson gson;

    public JsonToObjectConverterGson(Gson gson) {
        this.gson = Objects.requireNonNull(gson, "gson");
    }

    public JsonToObjectConverterGson() {
        this(new Gson());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T jsonToObject(InputStream stream, TypeReference<T> typeReference) {
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream));){
            Object object = this.gson.fromJson(jsonReader, typeReference.getType());
            return (T)object;
        }
        catch (IOException exception) {
            throw new JsonConverterException(exception);
        }
    }

    @Override
    public <T> T jsonToObject(String content, TypeReference<T> typeReference) {
        return (T)this.gson.fromJson(content, typeReference.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T jsonToObject(InputStream stream, Class<T> type) {
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream));){
            Object object = this.gson.fromJson(jsonReader, type);
            return (T)object;
        }
        catch (IOException exception) {
            throw new JsonConverterException(exception);
        }
    }

    @Override
    public <T> T jsonToObject(String content, Class<T> type) {
        return (T)this.gson.fromJson(content, type);
    }

    @Override
    public Optional<InputStream> objectToJson(Object conteudo) {
        try {
            return conteudo != null ? Optional.of(IOUtils.toInputStream((String)this.gson.toJson(conteudo))) : Optional.empty();
        }
        catch (JsonIOException exception) {
            throw new JsonConverterException("Erro ao converter objeto para JSON: " + conteudo, exception);
        }
    }

    @Override
    public Object getUnderlyingImplementation() {
        return this.gson;
    }
}

