/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.script;

import br.jus.tst.tstunit.annotation.AnnotationExtractor;
import br.jus.tst.tstunit.annotation.AnnotationHandler;
import br.jus.tst.tstunit.dbunit.script.ExecutorScripts;
import br.jus.tst.tstunit.dbunit.script.RodarScriptAntes;
import br.jus.tst.tstunit.dbunit.script.RodarScriptDepois;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.runners.model.FrameworkMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RodarScriptHandler
implements AnnotationHandler<ExecutorScripts> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RodarScriptHandler.class);
    private final String scriptsDirectory;
    private final Supplier<Connection> jdbcConnectionSupplier;
    private final AnnotationExtractor annotationExtractor;

    public RodarScriptHandler(String scriptsDirectory, Supplier<Connection> jdbcConnectionSupplier, AnnotationExtractor annotationExtractor) {
        this.scriptsDirectory = Objects.requireNonNull(scriptsDirectory, "scriptsDirectory");
        this.jdbcConnectionSupplier = Objects.requireNonNull(jdbcConnectionSupplier, "jdbcConnectionSupplier");
        this.annotationExtractor = Objects.requireNonNull(annotationExtractor, "annotationExtractor");
    }

    public Optional<ExecutorScripts> processar(FrameworkMethod method) {
        List<String> scriptsBefore = this.annotationExtractor.getAnnotationsFromMethodOrClass(method, RodarScriptAntes.class).stream().flatMap(anotacao -> Arrays.stream(anotacao.value())).map(caminhoArquivo -> this.buildCaminhoArquivo(this.scriptsDirectory, (String)caminhoArquivo)).collect(Collectors.toList());
        LOGGER.debug("Scripts a serem executados antes dos testes: {}", scriptsBefore);
        List<String> scriptsAfter = this.annotationExtractor.getAnnotationsFromMethodOrClass(method, RodarScriptDepois.class).stream().flatMap(anotacao -> Arrays.stream(anotacao.value())).map(caminhoArquivo -> this.buildCaminhoArquivo(this.scriptsDirectory, (String)caminhoArquivo)).collect(Collectors.toList());
        LOGGER.debug("Scripts a serem executados ap\u00f3s os testes: {}", scriptsAfter);
        return Optional.of(new ExecutorScripts(scriptsBefore, scriptsAfter, this.jdbcConnectionSupplier));
    }

    private String buildCaminhoArquivo(String directory, String nomeArquivo) {
        return directory + File.separatorChar + nomeArquivo;
    }
}

