/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.script;

import br.jus.tst.tstunit.dbunit.script.ScriptRunner;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.h2.message.DbException;
import org.h2.tools.RunScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2ScriptRunner
implements ScriptRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(H2ScriptRunner.class);
    private final transient Connection connection;

    public H2ScriptRunner(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "connection");
        try {
            Validate.isTrue((!connection.isClosed() ? 1 : 0) != 0, (String)"Conex\u00e3o inv\u00e1lida", (Object[])new Object[0]);
        }
        catch (SQLException exception) {
            throw new IllegalArgumentException("Conex\u00e3o inv\u00e1lida", exception);
        }
    }

    @Override
    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            LOGGER.debug("Executando {} na conex\u00e3o JDBC {}", (Object)reader, (Object)this.connection);
            RunScript.execute((Connection)this.connection, (Reader)reader);
        }
        catch (DbException exception) {
            throw new SQLException(exception);
        }
    }
}

