/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.script;

import br.jus.tst.tstunit.dbunit.DBUnitException;
import br.jus.tst.tstunit.dbunit.script.DefaultScriptRunner;
import br.jus.tst.tstunit.dbunit.script.ScriptRunner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorScripts
implements Serializable {
    private static final long serialVersionUID = 1089276331709009669L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorScripts.class);
    private static final String DIRETORIO_LOGS_PADRAO = "target";
    private final transient Supplier<Connection> jdbcConnectionSupplier;
    private final transient List<String> scriptsBefore;
    private final transient List<String> scriptsAfter;
    private transient Function<Connection, ScriptRunner> scriptRunnerSupplier;

    public ExecutorScripts(List<String> scriptsBefore, List<String> scriptsAfter, Supplier<Connection> jdbcConnectionSupplier) {
        this.scriptsBefore = CollectionUtils.isEmpty(scriptsBefore) ? Collections.emptyList() : new ArrayList<String>(scriptsBefore);
        this.scriptsAfter = CollectionUtils.isEmpty(scriptsAfter) ? Collections.emptyList() : new ArrayList<String>(scriptsAfter);
        this.jdbcConnectionSupplier = Objects.requireNonNull(jdbcConnectionSupplier, "jdbcConnectionSupplier");
        this.identificarScriptRunner(jdbcConnectionSupplier);
    }

    private void identificarScriptRunner(Supplier<Connection> jdbcConnectionSupplier) {
        String provedorBancoDados;
        try (Connection connection2 = jdbcConnectionSupplier.get();){
            provedorBancoDados = StringUtils.deleteWhitespace((String)connection2.getMetaData().getDatabaseProductName());
            LOGGER.debug("Provedor de banco de dados: {}", (Object)provedorBancoDados);
        }
        catch (SQLException exception) {
            throw new DBUnitException("Erro ao identificar provedor de banco de dados", exception);
        }
        try {
            Class<?> scriptRunnerClass = Class.forName(String.format("%s.%sScriptRunner", ScriptRunner.class.getPackage().getName(), provedorBancoDados), false, Thread.currentThread().getContextClassLoader());
            LOGGER.info("Utilizando implementa\u00e7\u00e3o do {} para executar Scripts SQL", (Object)provedorBancoDados);
            this.scriptRunnerSupplier = connection -> this.newScriptRunner((Class<? extends ScriptRunner>)scriptRunnerClass, (Connection)connection);
        }
        catch (ClassNotFoundException exception) {
            LOGGER.debug("N\u00e3o h\u00e1 implementa\u00e7\u00e3o espec\u00edfica para o {}", (Object)provedorBancoDados, (Object)exception);
            LOGGER.info("Utilizando implementa\u00e7\u00e3o pr\u00f3pria para executar Scripts SQL");
            this.scriptRunnerSupplier = connection -> new DefaultScriptRunner((Connection)connection, false, true);
            DefaultScriptRunner.setLogsDir(new File(DIRETORIO_LOGS_PADRAO));
        }
    }

    private ScriptRunner newScriptRunner(Class<? extends ScriptRunner> scriptRunnerClass, Connection connection) {
        try {
            return (ScriptRunner)ConstructorUtils.invokeConstructor(scriptRunnerClass, (Object[])new Object[]{connection}, (Class[])new Class[]{Connection.class});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new DBUnitException("Erro ao instanciar executor de Scripts: " + scriptRunnerClass, exception);
        }
    }

    public void executarScriptsAntes() throws SQLException, IOException {
        this.executarScripts(this.scriptsBefore);
    }

    public void executarScriptsDepois() throws SQLException, IOException {
        this.executarScripts(this.scriptsAfter);
    }

    private void executarScripts(List<String> arquivosScript) throws SQLException, IOException {
        for (String arquivoScript : arquivosScript) {
            LOGGER.info("Executando script: {}", (Object)arquivoScript);
            Connection connection = this.jdbcConnectionSupplier.get();
            Throwable throwable = null;
            try {
                InputStreamReader fileReader = this.openReader(arquivoScript);
                Throwable throwable2 = null;
                try {
                    this.scriptRunnerSupplier.apply(connection).runScript(fileReader);
                    connection.commit();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fileReader == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((Reader)fileReader).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((Reader)fileReader).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                connection.close();
            }
        }
    }

    private InputStreamReader openReader(String arquivoScript) throws FileNotFoundException {
        Optional<InputStream> inputStream = Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResourceAsStream(arquivoScript));
        return new InputStreamReader(inputStream.orElseThrow(() -> new FileNotFoundException(arquivoScript)));
    }
}

