/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.jdbc;

import br.jus.tst.tstunit.dbunit.jdbc.JdbcException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class JdbcConnectionSupplier
implements Supplier<Connection> {
    private static final String NOME_PROPRIEDADE_DRIVER_CLASS = "driverClass";
    private static final String NOME_PROPRIEDADE_DB_URL = "url";
    private final Properties propriedadesJdbc = new Properties();

    public JdbcConnectionSupplier(Properties propriedadesJdbc) {
        this.propriedadesJdbc.putAll((Map<?, ?>)Objects.requireNonNull(propriedadesJdbc, "propriedadesJdbc"));
    }

    @Override
    public Connection get() {
        try {
            Class.forName(this.validarPropriedadeExistente(NOME_PROPRIEDADE_DRIVER_CLASS));
            return DriverManager.getConnection(this.validarPropriedadeExistente(NOME_PROPRIEDADE_DB_URL), this.propriedadesJdbc);
        }
        catch (ClassNotFoundException | SQLException exception) {
            throw new JdbcException("Erro ao abrir conex\u00e3o JDBC", exception);
        }
    }

    private String validarPropriedadeExistente(String nomePropriedade) {
        String valorPropriedade = this.propriedadesJdbc.getProperty(nomePropriedade);
        Validate.validState((boolean)StringUtils.isNotBlank((CharSequence)valorPropriedade), (String)"Propriedade '%s' n\u00e3o definida", (Object[])new Object[]{nomePropriedade});
        return valorPropriedade;
    }

    public Properties getPropriedadesJdbc() {
        return (Properties)this.propriedadesJdbc.clone();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("propriedadesJdbc", (Object)this.propriedadesJdbc).toString();
    }
}

