/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.dtd;

import br.jus.tst.tstunit.annotation.AnnotationHandler;
import br.jus.tst.tstunit.dbunit.dtd.GeradorDtd;
import br.jus.tst.tstunit.dbunit.dtd.GerarDtd;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.junit.runners.model.FrameworkMethod;

public class GerarDtdHandler
implements AnnotationHandler<GeradorDtd>,
Serializable {
    private static final long serialVersionUID = 4493224015962106560L;
    private final Supplier<Connection> jdbcConnectionSupplier;
    private Optional<IDataTypeFactory> dataTypeFactoryOptional;

    public GerarDtdHandler(Supplier<Connection> jdbcConnectionSupplier) {
        this.jdbcConnectionSupplier = Objects.requireNonNull(jdbcConnectionSupplier, "jdbcConnectionSupplier");
        this.dataTypeFactoryOptional = null;
    }

    public Optional<GeradorDtd> processar(FrameworkMethod method) {
        Optional<GeradorDtd> geradorDtdOptional;
        GerarDtd gerarDtd = (GerarDtd)Objects.requireNonNull(method, "method").getAnnotation(GerarDtd.class);
        if (gerarDtd != null) {
            GeradorDtd geradorDtd = new GeradorDtd(this.jdbcConnectionSupplier, new File(gerarDtd.value()));
            geradorDtd.setDataTypeFactory(this.dataTypeFactoryOptional);
            geradorDtdOptional = Optional.of(geradorDtd);
        } else {
            geradorDtdOptional = Optional.empty();
        }
        return geradorDtdOptional;
    }

    public Supplier<Connection> getJdbcConnectionSupplier() {
        return this.jdbcConnectionSupplier;
    }

    public Optional<IDataTypeFactory> getDataTypeFactory() {
        return this.dataTypeFactoryOptional;
    }

    public void setDataTypeFactory(Optional<IDataTypeFactory> dataTypeFactoryOptional) {
        this.dataTypeFactoryOptional = dataTypeFactoryOptional;
    }
}

