/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.dtd;

import br.jus.tst.tstunit.dbunit.DBUnitException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.xml.FlatDtdWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeradorDtd {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeradorDtd.class);
    private final Supplier<Connection> jdbcConnectionSupplier;
    private final File arquivoDtd;
    private Optional<IDataTypeFactory> dataTypeFactoryOptional;

    public GeradorDtd(Supplier<Connection> jdbcConnectionSupplier, File arquivoDtd) {
        this.jdbcConnectionSupplier = Objects.requireNonNull(jdbcConnectionSupplier, "jdbcConnectionSupplier");
        this.arquivoDtd = Objects.requireNonNull(arquivoDtd, "arquivoDtd");
    }

    public void gerar() {
        LOGGER.info("Gerando arquivo DTD a partir do schema do banco");
        try (Connection jdbcConnection = this.jdbcConnectionSupplier.get();){
            DatabaseConnection connection = new DatabaseConnection(jdbcConnection);
            this.dataTypeFactoryOptional.ifPresent(arg_0 -> GeradorDtd.lambda$gerar$0((IDatabaseConnection)connection, arg_0));
            IDataSet dataSet = connection.createDataSet();
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(this.arquivoDtd));
            FlatDtdWriter datasetWriter = new FlatDtdWriter((Writer)out);
            datasetWriter.setContentModel(FlatDtdWriter.CHOICE);
            datasetWriter.write(dataSet);
            LOGGER.info("Arquivo DTD gerado: {}", (Object)this.arquivoDtd);
        }
        catch (FileNotFoundException | SQLException | DatabaseUnitException exception) {
            throw new DBUnitException("Erro ao gerar arquivo DTD do schema do banco", exception);
        }
    }

    public Optional<IDataTypeFactory> getDataTypeFactory() {
        return this.dataTypeFactoryOptional;
    }

    public void setDataTypeFactory(Optional<IDataTypeFactory> dataTypeFactoryOptional) {
        this.dataTypeFactoryOptional = dataTypeFactoryOptional;
    }

    private static /* synthetic */ void lambda$gerar$0(IDatabaseConnection connection, IDataTypeFactory dataTypeFactory) {
        connection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)dataTypeFactory);
    }
}

