/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.dataset;

import br.jus.tst.tstunit.annotation.AnnotationExtractor;
import br.jus.tst.tstunit.annotation.AnnotationHandler;
import br.jus.tst.tstunit.dbunit.DBUnitException;
import br.jus.tst.tstunit.dbunit.dataset.DatabaseLoader;
import br.jus.tst.tstunit.dbunit.dataset.OperacaoDataSet;
import br.jus.tst.tstunit.dbunit.dataset.UsarDataSet;
import br.jus.tst.tstunit.dbunit.operation.DbUnitOperations;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.junit.runners.model.FrameworkMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsarDataSetHandler
implements AnnotationHandler<DatabaseLoader> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsarDataSetHandler.class);
    private final String datasetsDirectory;
    private final Supplier<Connection> jdbcConnectionSupplier;
    private final AnnotationExtractor annotationExtractor;
    private String operacaoAntesTestesDefault;
    private String operacaoAposTestesDefault;
    private String nomeSchema;
    private Optional<IDataTypeFactory> dataTypeFactoryOptional;

    public UsarDataSetHandler(String datasetsDirectory, String operacaoAntesTestesDefault, String operacaoAposTestesDefault, Supplier<Connection> jdbcConnectionSupplier, AnnotationExtractor annotationExtractor) {
        this.datasetsDirectory = Objects.requireNonNull(datasetsDirectory, "datasetsDirectory");
        this.operacaoAntesTestesDefault = Objects.requireNonNull(operacaoAntesTestesDefault, "operacaoAntesTestesDefault");
        this.operacaoAposTestesDefault = Objects.requireNonNull(operacaoAposTestesDefault, "operacaoAposTestesDefault");
        this.jdbcConnectionSupplier = Objects.requireNonNull(jdbcConnectionSupplier, "jdbcConnectionSupplier");
        this.annotationExtractor = Objects.requireNonNull(annotationExtractor, "annotationExtractor");
    }

    public Optional<DatabaseLoader> processar(FrameworkMethod method) {
        Optional<DatabaseLoader> databaseLoaderOptional;
        ArrayList<OperacaoDataSet> operacaoDataSets = new ArrayList<OperacaoDataSet>();
        this.annotationExtractor.getAnnotationsFromMethodOrClass(Objects.requireNonNull(method, "method"), UsarDataSet.class).stream().forEach(usarDataSet -> {
            String nomeArquivo = this.buildCaminhoArquivo(this.datasetsDirectory, usarDataSet.value());
            operacaoDataSets.add(OperacaoDataSet.nova().comDataSet(this.carregarDataSet(nomeArquivo)).operacaoPreTestes(DbUnitOperations.carregarOperacao(usarDataSet.operacaoPreTestes().getNome(), this.operacaoAntesTestesDefault)).operacaoPosTestes(DbUnitOperations.carregarOperacao(usarDataSet.operacaoPosTestes().getNome(), this.operacaoAposTestesDefault)).build());
        });
        if (!operacaoDataSets.isEmpty()) {
            DatabaseLoader databaseLoader = new DatabaseLoader(operacaoDataSets, this.jdbcConnectionSupplier);
            databaseLoader.setSchema(this.nomeSchema);
            databaseLoader.setDataTypeFactory(this.dataTypeFactoryOptional);
            databaseLoaderOptional = Optional.of(databaseLoader);
        } else {
            databaseLoaderOptional = Optional.empty();
        }
        return databaseLoaderOptional;
    }

    private String buildCaminhoArquivo(String directory, String nomeArquivo) {
        return directory + File.separatorChar + nomeArquivo;
    }

    private IDataSet carregarDataSet(String nomeArquivo) {
        LOGGER.debug("Carregando arquivo de DataSet: {}", (Object)nomeArquivo);
        Optional<InputStream> dataSetStreamOptional = Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResourceAsStream(nomeArquivo));
        try {
            return new FlatXmlDataSetBuilder().setDtdMetadata(false).build(dataSetStreamOptional.orElseThrow(() -> new DBUnitException("O arquivo de DataSet n\u00e3o foi encontrado no classpath: " + nomeArquivo)));
        }
        catch (DataSetException exception) {
            throw new DBUnitException("Erro ao carregar arquivo de DataSet: " + nomeArquivo, exception);
        }
    }

    public String getDatasetsDirectory() {
        return this.datasetsDirectory;
    }

    public Supplier<Connection> getJdbcConnectionSupplier() {
        return this.jdbcConnectionSupplier;
    }

    public AnnotationExtractor getAnnotationExtractor() {
        return this.annotationExtractor;
    }

    public String getOperacaoAntesTestesDefault() {
        return this.operacaoAntesTestesDefault;
    }

    public String getOperacaoAposTestesDefault() {
        return this.operacaoAposTestesDefault;
    }

    public String getNomeSchema() {
        return this.nomeSchema;
    }

    public void setNomeSchema(String nomeSchema) {
        this.nomeSchema = nomeSchema;
    }

    public Optional<IDataTypeFactory> getDataTypeFactory() {
        return this.dataTypeFactoryOptional;
    }

    public void setDataTypeFactory(Optional<IDataTypeFactory> dataTypeFactoryOptional) {
        this.dataTypeFactoryOptional = dataTypeFactoryOptional;
    }
}

