/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.dataset;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;

public final class OperacaoDataSet
implements Serializable {
    private static final long serialVersionUID = 3617026518809867576L;
    private transient IDataSet dataSet;
    private transient DatabaseOperation operacaoAntesTestes;
    private transient DatabaseOperation operacaoAposTestes;

    private OperacaoDataSet() {
    }

    public static Builder nova() {
        return new Builder();
    }

    public void executarOperacaoPreTestes(IDatabaseConnection connection) throws DatabaseUnitException, SQLException {
        this.operacaoAntesTestes.execute(connection, this.dataSet);
    }

    public void executarOperacaoPosTestes(IDatabaseConnection connection) throws DatabaseUnitException, SQLException {
        this.operacaoAposTestes.execute(connection, this.dataSet);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dataSet", (Object)this.dataSet).append("operacaoAntesTestes", (Object)this.operacaoAntesTestes).append("operacaoAposTestes", (Object)this.operacaoAposTestes).toString();
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<OperacaoDataSet> {
        private OperacaoDataSet instancia = new OperacaoDataSet();

        public Builder comDataSet(IDataSet dataSet) {
            this.instancia.dataSet = Objects.requireNonNull(dataSet, "dataSet");
            return this;
        }

        public Builder operacaoPreTestes(DatabaseOperation operacao) {
            this.instancia.operacaoAntesTestes = Objects.requireNonNull(operacao, "operacao");
            return this;
        }

        public Builder operacaoPosTestes(DatabaseOperation operacao) {
            this.instancia.operacaoAposTestes = Objects.requireNonNull(operacao, "operacao");
            return this;
        }

        public OperacaoDataSet build() {
            return this.instancia;
        }
    }
}

