/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit.dataset;

import br.jus.tst.tstunit.dbunit.DBUnitException;
import br.jus.tst.tstunit.dbunit.dataset.OperacaoDataSet;
import br.jus.tst.tstunit.dbunit.jdbc.JdbcException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseLoader.class);
    private final Supplier<Connection> jdbcConnectionSupplier;
    private final List<OperacaoDataSet> operacoes;
    private Optional<IDataTypeFactory> dataTypeFactoryOptional;
    private String schema;

    public DatabaseLoader(List<OperacaoDataSet> operacoes, Supplier<Connection> jdbcConnectionSupplier) {
        this.operacoes = new ArrayList<OperacaoDataSet>((Collection)Objects.requireNonNull(operacoes, "operacoes"));
        this.jdbcConnectionSupplier = Objects.requireNonNull(jdbcConnectionSupplier, "jdbcConnectionSupplier");
        this.dataTypeFactoryOptional = Optional.empty();
    }

    public void carregarBancoDados() {
        LOGGER.debug("Carga do banco de dados");
        try (Connection jdbcConnection = this.jdbcConnectionSupplier.get();){
            DatabaseConnection connection = this.openDbUnitConnection(jdbcConnection);
            this.dataTypeFactoryOptional.ifPresent(arg_0 -> DatabaseLoader.lambda$carregarBancoDados$0((IDatabaseConnection)connection, arg_0));
            this.operacoes.forEach(arg_0 -> this.lambda$carregarBancoDados$1((IDatabaseConnection)connection, arg_0));
        }
        catch (JdbcException | SQLException | DatabaseUnitException exception) {
            throw new DBUnitException("Erro ao efetuar carga do banco de dados", exception);
        }
    }

    private void executarOperacaoPreTestes(OperacaoDataSet operacao, IDatabaseConnection connection) {
        try {
            LOGGER.debug("Executando opera\u00e7\u00e3o pr\u00e9-testes: {}", (Object)operacao);
            operacao.executarOperacaoPreTestes(connection);
        }
        catch (SQLException | DatabaseUnitException exception) {
            throw new DBUnitException("Erro ao executar opera\u00e7\u00e3o pr\u00e9-testes", exception);
        }
    }

    public void limparBancoDados() {
        LOGGER.debug("Limpeza do banco de dados");
        try (Connection jdbcConnection = this.jdbcConnectionSupplier.get();){
            DatabaseConnection connection = this.openDbUnitConnection(jdbcConnection);
            for (int i = this.operacoes.size() - 1; i >= 0; --i) {
                this.executarOperacaoPosTestes(this.operacoes.get(i), (IDatabaseConnection)connection);
            }
        }
        catch (JdbcException | SQLException | DatabaseUnitException exception) {
            throw new DBUnitException("Erro ao efetuar limpeza do banco de dados", exception);
        }
    }

    private void executarOperacaoPosTestes(OperacaoDataSet operacao, IDatabaseConnection connection) {
        try {
            LOGGER.debug("Executando opera\u00e7\u00e3o p\u00f3s-testes: {}", (Object)operacao);
            operacao.executarOperacaoPosTestes(connection);
        }
        catch (SQLException | DatabaseUnitException exception) {
            throw new DBUnitException("Erro ao executar opera\u00e7\u00e3o p\u00f3s-testes", exception);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Optional<IDataTypeFactory> getDataTypeFactory() {
        return this.dataTypeFactoryOptional;
    }

    public void setDataTypeFactory(Optional<IDataTypeFactory> dataTypeFactoryOptional) {
        this.dataTypeFactoryOptional = dataTypeFactoryOptional;
    }

    protected DatabaseConnection openDbUnitConnection(Connection jdbcConnection) throws DatabaseUnitException {
        LOGGER.debug("Criando conex\u00e3o do DBUnit a partir da conex\u00e3o JDBC: {}", (Object)jdbcConnection);
        return new DatabaseConnection(jdbcConnection, this.schema);
    }

    private /* synthetic */ void lambda$carregarBancoDados$1(IDatabaseConnection connection, OperacaoDataSet operacaoAtual) {
        this.executarOperacaoPreTestes(operacaoAtual, connection);
    }

    private static /* synthetic */ void lambda$carregarBancoDados$0(IDatabaseConnection connection, IDataTypeFactory dataTypeFactory) {
        LOGGER.debug("Definindo propriedade de conex\u00e3o: {} = {}", (Object)"http://www.dbunit.org/properties/datatypeFactory", (Object)dataTypeFactory);
        connection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)dataTypeFactory);
    }
}

