/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit;

import br.jus.tst.tstunit.dbunit.DBUnitException;
import br.jus.tst.tstunit.dbunit.dataset.DatabaseLoader;
import br.jus.tst.tstunit.dbunit.dtd.GeradorDtd;
import br.jus.tst.tstunit.dbunit.script.ExecutorScripts;
import br.jus.tst.tstunit.time.MedidorTempoExecucao;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.builder.Builder;
import org.junit.runners.model.Statement;

public class DbUnitStatement
extends Statement {
    private final Statement defaultStatement;
    private final Optional<DatabaseLoader> databaseLoader;
    private final Optional<ExecutorScripts> executorScripts;
    private final Optional<GeradorDtd> geradorDtd;

    DbUnitStatement(Statement defaultStatement, Optional<DatabaseLoader> databaseLoader, Optional<ExecutorScripts> executorScripts, Optional<GeradorDtd> geradorDtd) {
        this.defaultStatement = Objects.requireNonNull(defaultStatement, "defaultStatement");
        this.databaseLoader = databaseLoader;
        this.geradorDtd = geradorDtd;
        this.executorScripts = executorScripts;
    }

    public static DbUnitStatementBuilder aPartirDo(Statement defaultStatement) {
        return new DbUnitStatementBuilder(Objects.requireNonNull(defaultStatement, "defaultStatement"));
    }

    public void evaluate() throws Throwable {
        MedidorTempoExecucao medidorTempoExecucao = MedidorTempoExecucao.getInstancia();
        medidorTempoExecucao.medir(() -> this.executorScripts.ifPresent(this.executarScriptAntes()), "Execu\u00e7\u00e3o de Scripts ANTES do teste");
        medidorTempoExecucao.medir(() -> this.geradorDtd.ifPresent(GeradorDtd::gerar), "Gera\u00e7\u00e3o de DTD");
        medidorTempoExecucao.medir(() -> this.databaseLoader.ifPresent(DatabaseLoader::carregarBancoDados), "Carga do Banco de Dados");
        try {
            this.defaultStatement.evaluate();
        }
        finally {
            medidorTempoExecucao.medir(() -> this.databaseLoader.ifPresent(DatabaseLoader::limparBancoDados), "Limpeza do Banco de Dados");
            medidorTempoExecucao.medir(() -> this.executorScripts.ifPresent(this.executarScriptDepois()), "Execu\u00e7\u00e3o de Scripts AP\u00d3S o teste");
        }
    }

    private Consumer<? super ExecutorScripts> executarScriptAntes() {
        return runner -> {
            try {
                runner.executarScriptsAntes();
            }
            catch (IOException | SQLException exception) {
                throw new DBUnitException("Erro ao executar script antes do teste", exception);
            }
        };
    }

    private Consumer<? super ExecutorScripts> executarScriptDepois() {
        return runner -> {
            try {
                runner.executarScriptsDepois();
            }
            catch (IOException | SQLException exception) {
                throw new DBUnitException("Erro ao executar script ap\u00f3s o teste", exception);
            }
        };
    }

    public static class DbUnitStatementBuilder
    implements Builder<DbUnitStatement> {
        private Optional<DatabaseLoader> databaseLoader;
        private Optional<GeradorDtd> geradorDtd;
        private Optional<ExecutorScripts> executorScripts;
        private Statement defaultStatement;

        DbUnitStatementBuilder(Statement defaultStatement) {
            this.defaultStatement = defaultStatement;
        }

        public DbUnitStatementBuilder usandoDatabaseLoader(Optional<DatabaseLoader> databaseLoader) {
            this.databaseLoader = databaseLoader;
            return this;
        }

        public DbUnitStatementBuilder usandoGeradorDtd(Optional<GeradorDtd> geradorDtd) {
            this.geradorDtd = geradorDtd;
            return this;
        }

        public DbUnitStatementBuilder usandoScriptRunner(Optional<ExecutorScripts> executorScripts) {
            this.executorScripts = executorScripts;
            return this;
        }

        public DbUnitStatement build() {
            return new DbUnitStatement(this.defaultStatement, this.databaseLoader, this.executorScripts, this.geradorDtd);
        }
    }
}

