/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit;

import br.jus.tst.tstunit.Configuracao;
import br.jus.tst.tstunit.TestUnitException;
import br.jus.tst.tstunit.annotation.AnnotationExtractor;
import br.jus.tst.tstunit.dbunit.DBUnitException;
import br.jus.tst.tstunit.dbunit.DbUnitStatement;
import br.jus.tst.tstunit.dbunit.dataset.UsarDataSetHandler;
import br.jus.tst.tstunit.dbunit.dtd.GerarDtdHandler;
import br.jus.tst.tstunit.dbunit.jdbc.JdbcConnectionSupplier;
import br.jus.tst.tstunit.dbunit.script.RodarScriptHandler;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitRunner
implements Serializable {
    private static final long serialVersionUID = -1862055645135908142L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUnitRunner.class);
    private static final String DIRETORIO_DATASETS_PADRAO = "datasets";
    private static final String DIRETORIO_SCRIPTS_PADRAO = "scripts";
    private static final String OPERACAO_BEFORE_TESTS_PADRAO = "CLEAN_INSERT";
    private static final String OPERACAO_AFTER_TESTS_PADRAO = "DELETE_ALL";
    private final transient Class<?> classeTeste;
    private final transient Configuracao configuracao;
    private final transient JdbcConnectionSupplier jdbcConnectionSupplier;
    private final transient AnnotationExtractor annotationExtractor;
    private final transient GerarDtdHandler gerarDtdHandler;
    private final transient RodarScriptHandler rodarScriptHandler;
    private final transient UsarDataSetHandler usarDataSetHandler;

    public DbUnitRunner(Class<?> classeTeste, String nomeSchema, Configuracao configuracao) throws TestUnitException {
        this.classeTeste = Objects.requireNonNull(classeTeste, "classeTeste");
        this.configuracao = Objects.requireNonNull(configuracao, "configuracao");
        this.jdbcConnectionSupplier = new JdbcConnectionSupplier(this.getConfiguracoesJdbc());
        this.gerarDtdHandler = new GerarDtdHandler(this.jdbcConnectionSupplier);
        this.gerarDtdHandler.setDataTypeFactory(this.getDataTypeFactory());
        this.annotationExtractor = new AnnotationExtractor(classeTeste);
        this.rodarScriptHandler = new RodarScriptHandler((String)StringUtils.defaultIfBlank((CharSequence)this.getDiretorioScriptsConfigurado(), (CharSequence)DIRETORIO_SCRIPTS_PADRAO), this.jdbcConnectionSupplier, this.annotationExtractor);
        this.usarDataSetHandler = new UsarDataSetHandler(this.getDiretorioDatasets(), Optional.ofNullable(this.getConfiguracoesDbUnit().getProperty("beforeTests.operation")).orElse(OPERACAO_BEFORE_TESTS_PADRAO), Optional.ofNullable(this.getConfiguracoesDbUnit().getProperty("afterTests.operation")).orElse(OPERACAO_AFTER_TESTS_PADRAO), this.jdbcConnectionSupplier, this.annotationExtractor);
        this.usarDataSetHandler.setDataTypeFactory(this.getDataTypeFactory());
        this.usarDataSetHandler.setNomeSchema(nomeSchema);
    }

    public Statement criarStatement(Statement statement, FrameworkMethod method) throws TestUnitException {
        Objects.requireNonNull(statement, "statement");
        Objects.requireNonNull(method, "method");
        LOGGER.debug("Criando Statement para o m\u00e9todo {}", (Object)method);
        return DbUnitStatement.aPartirDo(statement).usandoDatabaseLoader(this.usarDataSetHandler.processar(method)).usandoScriptRunner(this.rodarScriptHandler.processar(method)).usandoGeradorDtd(this.gerarDtdHandler.processar(method)).build();
    }

    private String getDiretorioDatasets() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getDiretorioDatasetsConfigurado(), (CharSequence)DIRETORIO_DATASETS_PADRAO);
    }

    private String getDiretorioDatasetsConfigurado() {
        return (String)this.getConfiguracoesDbUnit().get("datasets.dir");
    }

    private String getDiretorioScriptsConfigurado() {
        return (String)this.getConfiguracoesDbUnit().get("scripts.dir");
    }

    private Optional<IDataTypeFactory> getDataTypeFactory() {
        String dataTypeFactoryClassProperty = (String)this.getConfiguracoesDbUnit().get("dataTypeFactoryClass");
        return Optional.ofNullable(dataTypeFactoryClassProperty).map(dataTypeFactoryClass -> {
            try {
                return Optional.of((IDataTypeFactory)Class.forName(dataTypeFactoryClass).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                throw new DBUnitException("Erro ao instanciar classe de DataTypeFactory configurada: " + dataTypeFactoryClass, exception);
            }
        }).orElse(Optional.empty());
    }

    private Properties getConfiguracoesJdbc() {
        return this.configuracao.getSubPropriedades("jdbc");
    }

    private Properties getConfiguracoesDbUnit() {
        return this.configuracao.getSubPropriedades("dbunit");
    }

    public Class<?> getClasseTeste() {
        return this.classeTeste;
    }
}

