/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.dbunit;

import br.jus.tst.tstunit.AbstractExtensao;
import br.jus.tst.tstunit.Configuracao;
import br.jus.tst.tstunit.TestUnitException;
import br.jus.tst.tstunit.dbunit.DbUnitRunner;
import br.jus.tst.tstunit.dbunit.HabilitarDbUnit;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitExtensao
extends AbstractExtensao<HabilitarDbUnit> {
    private static final long serialVersionUID = 4420119979355499371L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUnitExtensao.class);
    private transient DbUnitRunner dbUnitRunner;

    public DbUnitExtensao(Class<?> classeTeste) {
        super(classeTeste);
    }

    public void inicializar(Configuracao configuracao, RunNotifier notifier) throws TestUnitException {
        this.assertExtensaoHabilitada();
        LOGGER.info("DBUnit habilitado");
        HabilitarDbUnit habilitarDbUnit = this.classeTeste.getAnnotation(HabilitarDbUnit.class);
        this.dbUnitRunner = new DbUnitRunner(this.classeTeste, StringUtils.stripToNull((String)habilitarDbUnit.nomeSchema()), configuracao);
    }

    public Statement criarStatement(Statement defaultStatement, FrameworkMethod method) throws TestUnitException {
        this.assertExtensaoHabilitada();
        LOGGER.info("Ativando DBUnit");
        return this.dbUnitRunner.criarStatement(defaultStatement, method);
    }
}

