/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.time;

import br.jus.tst.tstunit.Configuracao;
import br.jus.tst.tstunit.TestUnitRuntimeException;
import com.diogonunes.jcdp.color.ColoredPrinter;
import com.diogonunes.jcdp.color.api.Ansi;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.time.StopWatch;

public final class MedidorTempoExecucao
implements Serializable {
    private static final long serialVersionUID = 3431653094150490207L;
    public static final String FORMATO_MENSAGENS_PADRAO = "\n[TEST Unit - MEDIDOR] %s levou %d milisegundos\n";
    private static final MedidorTempoExecucao INSTANCIA_SINGLETON = new MedidorTempoExecucao();
    private boolean habilitado;
    private String formatoMensagens;
    private transient long duracaoAlerta;
    private transient long duracaoPerigo;
    private transient boolean consoleAnsi;

    private MedidorTempoExecucao() {
    }

    public static MedidorTempoExecucao getInstancia() {
        return INSTANCIA_SINGLETON;
    }

    public void configurar(Configuracao configuracao) {
        Objects.requireNonNull(configuracao, "configuracao");
        Properties propriedades = configuracao.isCarregado() ? configuracao.getSubPropriedades("core.medidortempoexecucao") : new Properties();
        this.habilitado = BooleanUtils.toBoolean((String)propriedades.getProperty("habilitado"));
        this.formatoMensagens = Optional.ofNullable(propriedades.getProperty("mensagens.formato")).orElse(FORMATO_MENSAGENS_PADRAO);
        this.duracaoAlerta = Long.parseLong(Optional.ofNullable(propriedades.getProperty("duracao.alerta")).orElse("500"));
        this.duracaoPerigo = Long.parseLong(Optional.ofNullable(propriedades.getProperty("duracao.perigo")).orElse("1000"));
        this.consoleAnsi = BooleanUtils.toBoolean((String)Optional.ofNullable(propriedades.getProperty("consoleansi")).orElse("true"));
    }

    public void medir(Runnable runnable, String descricao) {
        Objects.requireNonNull(runnable, "runnable");
        if (this.habilitado) {
            StopWatch watch = new StopWatch();
            watch.start();
            runnable.run();
            watch.stop();
            this.log(descricao, watch.getTime());
        } else {
            runnable.run();
        }
    }

    public <T> T medir(Callable<T> callable, String descricao) throws Exception {
        T resultado;
        Objects.requireNonNull(callable, "callable");
        if (this.habilitado) {
            StopWatch watch = new StopWatch();
            watch.start();
            resultado = this.getResultado(callable);
            watch.stop();
            this.log(descricao, watch.getTime());
        } else {
            resultado = this.getResultado(callable);
        }
        return resultado;
    }

    private <T> T getResultado(Callable<T> callable) throws Exception {
        T resultado;
        try {
            resultado = callable.call();
        }
        catch (Exception exception) {
            throw this.habilitado ? new TestUnitRuntimeException("Erro ao computar resultado da chamada", exception) : exception;
        }
        return resultado;
    }

    public <T, R> Function<T, R> medir(Function<T, R> function, String descricao) {
        Objects.requireNonNull(function, "function");
        Function<Object, Object> newFunction = this.habilitado ? t -> {
            StopWatch watch = new StopWatch();
            watch.start();
            Object resultado = function.apply(t);
            watch.stop();
            this.log(descricao, watch.getTime());
            return resultado;
        } : function::apply;
        return newFunction;
    }

    public boolean isHabilitado() {
        return this.habilitado;
    }

    public void setHabilitado(boolean habilitado) {
        this.habilitado = habilitado;
    }

    public String getFormatoMensagens() {
        return this.formatoMensagens;
    }

    public void setFormatoMensagens(String formatoMensagens) {
        this.formatoMensagens = formatoMensagens;
    }

    private void log(String descricao, long tempo) {
        if (tempo > 0L) {
            String mensagem = String.format(this.formatoMensagens, descricao, tempo);
            if (this.consoleAnsi) {
                Ansi.FColor foregroundColor = this.identificarCorPeloTempo(tempo);
                ColoredPrinter printer = new ColoredPrinter.Builder(1, false).foreground(foregroundColor).build();
                printer.println((Object)mensagem);
                printer.clear();
            } else {
                System.out.println(mensagem);
            }
        }
    }

    private Ansi.FColor identificarCorPeloTempo(long tempo) {
        return tempo >= this.duracaoPerigo ? Ansi.FColor.RED : (tempo >= this.duracaoAlerta ? Ansi.FColor.YELLOW : Ansi.FColor.GREEN);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("habilitado", this.habilitado).append("formatoMensagens", (Object)this.formatoMensagens).append("duracaoAlerta", this.duracaoAlerta).append("duracaoPerigo", this.duracaoPerigo).append("consoleAnsi", this.consoleAnsi).toString();
    }
}

