/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.parameters;

import br.jus.tst.tstunit.TestUnitException;
import br.jus.tst.tstunit.TestUnitRunner;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.InitializationError;
import org.junit.runners.parameterized.TestWithParameters;

public class TestUnitParameterizedRunner
extends TestUnitRunner {
    private final List<Object> parametros;
    private final String nome;

    public TestUnitParameterizedRunner(TestWithParameters test) throws InitializationError {
        super(test.getTestClass().getJavaClass());
        this.parametros = test.getParameters();
        this.nome = test.getName();
    }

    @Override
    protected Object createTest() throws Exception {
        List<FrameworkField> annotatedFieldsByParameter = this.getAnnotatedFieldsByParameter();
        if (annotatedFieldsByParameter.size() != this.parametros.size()) {
            throw new TestUnitException("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + this.parametros.size() + ".");
        }
        Object testInstance = super.createTest();
        for (FrameworkField each : annotatedFieldsByParameter) {
            Field field = each.getField();
            Parameterized.Parameter annotation = field.getAnnotation(Parameterized.Parameter.class);
            int index = annotation.value();
            Object parametro = this.parametros.get(index);
            try {
                field.set(testInstance, parametro);
            }
            catch (IllegalArgumentException exception) {
                throw new TestUnitException(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + parametro + " that is not the right type (" + parametro.getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", exception);
            }
        }
        return testInstance;
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameterized.Parameter.class);
    }

    public String getNome() {
        return this.nome;
    }
}

