/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.runners.model.FrameworkMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationExtractor
implements Serializable {
    private static final long serialVersionUID = -4382015102432111794L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationExtractor.class);
    private final Class<?> classeTeste;

    public AnnotationExtractor(Class<?> classeTeste) {
        this.classeTeste = Objects.requireNonNull(classeTeste, "classeTeste");
    }

    public <T extends Annotation> List<T> getAnnotationsFromMethodOrClass(FrameworkMethod method, Class<T> annotationType) {
        ArrayList annotations = new ArrayList();
        CollectionUtils.addAll(annotations, (Object[])this.classeTeste.getDeclaredAnnotationsByType(annotationType));
        CollectionUtils.addAll(annotations, (Object[])method.getMethod().getDeclaredAnnotationsByType(annotationType));
        LOGGER.debug("Anota\u00e7\u00f5es identificadas: {}", annotations);
        return annotations;
    }
}

