/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit;

import br.jus.tst.tstunit.Configuracao;
import br.jus.tst.tstunit.Extensao;
import br.jus.tst.tstunit.ExtensoesLoader;
import br.jus.tst.tstunit.ImprimirNomeTeste;
import br.jus.tst.tstunit.PrintTestNameWatcher;
import br.jus.tst.tstunit.TestUnitException;
import br.jus.tst.tstunit.TestUnitRuntimeException;
import br.jus.tst.tstunit.time.MedidorTempoExecucao;
import br.jus.tst.tstunit.time.StatementComMedidor;
import java.util.List;
import java.util.Optional;
import org.junit.rules.TestRule;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUnitRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestUnitRunner.class);
    private static final String PACOTE_EXTENSOES = "br.jus.tst.tstunit";
    private static final Optional<String> NOME_ARQUIVO_PROPRIEDADES_PARAM = Optional.ofNullable(System.getProperty("nomeArquivoPropriedades"));
    private final transient Class<?> classeTeste;
    private final transient Configuracao configuracao;
    private final transient List<? extends Extensao<?>> extensoes;

    public TestUnitRunner(Class<?> classeTeste) throws InitializationError {
        super(classeTeste);
        this.classeTeste = classeTeste;
        this.configuracao = Configuracao.getInstance();
        NOME_ARQUIVO_PROPRIEDADES_PARAM.ifPresent(this.configuracao::setNomeArquivoPropriedades);
        try {
            this.configuracao.carregar();
        }
        catch (TestUnitException exception) {
            LOGGER.debug("Erro ao carregar propriedades", (Throwable)exception);
        }
        LOGGER.debug("Configurando Medidor de Tempo de Execu\u00e7\u00e3o");
        MedidorTempoExecucao.getInstancia().configurar(this.configuracao);
        this.extensoes = new ExtensoesLoader(PACOTE_EXTENSOES, classeTeste).carregarExtensoes();
        LOGGER.info("Extens\u00f5es habilitadas: {}", this.extensoes);
    }

    TestUnitRunner(Configuracao configuracao, ExtensoesLoader extensoesLoader) throws InitializationError {
        super(extensoesLoader.getClasseTeste());
        this.configuracao = configuracao;
        this.classeTeste = extensoesLoader.getClasseTeste();
        this.extensoes = extensoesLoader.carregarExtensoes();
        LOGGER.info("Extens\u00f5es habilitadas: {}", this.extensoes);
    }

    public void run(RunNotifier notifier) {
        LOGGER.debug("Inicializando {} extens\u00f5es", (Object)this.extensoes.size());
        this.extensoes.forEach(extensao -> {
            try {
                extensao.inicializar(this.configuracao, notifier);
            }
            catch (TestUnitException exception) {
                throw new TestUnitRuntimeException("Erro ao inicializar extens\u00e3o: " + extensao, exception);
            }
        });
        super.run(notifier);
    }

    protected Object createTest() throws Exception {
        Optional<Optional> instanciaPersonalizada = this.extensoes.stream().map(extensao -> extensao.getInstanciaPersonalizadaParaTestes()).filter(Optional::isPresent).findFirst();
        Object instanciaTeste = instanciaPersonalizada.orElse(Optional.of(super.createTest())).get();
        LOGGER.debug("Inst\u00e2ncia da classe de testes utilizada: {}", instanciaTeste);
        LOGGER.debug("Executando beforeTestes() de cada extens\u00e3o antes de executar os testes");
        this.extensoes.forEach(extensao -> extensao.beforeTestes(instanciaTeste));
        return instanciaTeste;
    }

    protected Statement classBlock(RunNotifier notifier) {
        final Statement statement = super.classBlock(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                statement.evaluate();
                LOGGER.debug("Executando afterTestes() de cada extens\u00e3o ap\u00f3s finalizados todos os testes");
                TestUnitRunner.this.extensoes.forEach(extensao -> extensao.afterTestes());
            }
        };
    }

    protected Statement methodBlock(FrameworkMethod method) {
        StatementComMedidor statement = new StatementComMedidor(super.methodBlock(method));
        for (Extensao<?> extensao : this.extensoes) {
            LOGGER.debug("Executando extens\u00e3o: {}", (Object)extensao.getClass().getSimpleName());
            try {
                statement = extensao.criarStatement(statement, method);
            }
            catch (TestUnitException exception) {
                throw new TestUnitRuntimeException("Erro ao executar m\u00e9todo: " + method, exception);
            }
        }
        return statement;
    }

    protected List<TestRule> getTestRules(Object target) {
        List rules = super.getTestRules(target);
        ImprimirNomeTeste imprimirNomeTeste = this.classeTeste.getAnnotation(ImprimirNomeTeste.class);
        if (imprimirNomeTeste == null && this.configuracao.getPropriedadeBoolean("core.printtestname.default").orElse(Boolean.TRUE).booleanValue()) {
            LOGGER.debug("Anota\u00e7\u00e3o @ImprimirNomeTeste ausente - utilizando o valor da configura\u00e7\u00e3o padr\u00e3o, que \u00e9 'true'");
            rules.add(new PrintTestNameWatcher());
        } else if (imprimirNomeTeste != null && imprimirNomeTeste.value()) {
            LOGGER.debug("Anota\u00e7\u00e3o @ImprimirNomeTeste presente e habilitada");
            rules.add(new PrintTestNameWatcher(imprimirNomeTeste.formatoMensagem()));
        }
        return rules;
    }
}

