/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class PrintTestNameWatcher
implements TestRule {
    public static final String FORMATO_MENSAGEM_PADRAO = ">>>>>>>>>> Executando: {0}.{1} <<<<<<<<<<";
    private final PrintStream stream;
    private final String formatoMensagem;

    public PrintTestNameWatcher(String formatoMensagem, PrintStream stream) {
        Objects.requireNonNull(stream, "stream");
        this.formatoMensagem = (String)StringUtils.defaultIfBlank((CharSequence)formatoMensagem, (CharSequence)FORMATO_MENSAGEM_PADRAO);
        this.stream = stream;
    }

    public PrintTestNameWatcher(String formatoMensagem) {
        this(formatoMensagem, System.out);
    }

    public PrintTestNameWatcher() {
        this(FORMATO_MENSAGEM_PADRAO);
    }

    public Statement apply(Statement statement, Description description) {
        this.stream.println();
        this.stream.println(MessageFormat.format(this.formatoMensagem, description.getClassName(), description.getMethodName()));
        this.stream.println();
        return statement;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public String getFormatoMensagem() {
        return this.formatoMensagem;
    }
}

