/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit;

import br.jus.tst.tstunit.Extensao;
import br.jus.tst.tstunit.TestUnitRuntimeException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensoesLoader
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensoesLoader.class);
    private static final long serialVersionUID = -6036814877869370373L;
    private final String basePackage;
    private final Class<?> classeTeste;

    public ExtensoesLoader(String basePackage, Class<?> classeTeste) {
        this.basePackage = Objects.requireNonNull(basePackage, "basePackage");
        this.classeTeste = Objects.requireNonNull(classeTeste, "classeTeste");
    }

    public List<Extensao<?>> carregarExtensoes() {
        LOGGER.debug("Carregando extens\u00f5es a partir do pacote: {}", (Object)this.basePackage);
        return new Reflections(this.basePackage, new Scanner[]{new SubTypesScanner()}).getSubTypesOf(Extensao.class).stream().filter(type -> !Modifier.isAbstract(type.getModifiers())).map(this::newInstance).filter(Extensao::isHabilitada).collect(Collectors.toList());
    }

    private Extensao<?> newInstance(Class<?> classeExtensao) {
        try {
            LOGGER.debug("Criando nova inst\u00e2ncia da extens\u00e3o {} para a classe de teste: {}", classeExtensao, this.classeTeste);
            return (Extensao)classeExtensao.getConstructor(this.classeTeste.getClass()).newInstance(this.classeTeste);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new TestUnitRuntimeException("Erro ao instanciar classe da extens\u00e3o: " + classeExtensao, exception);
        }
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Class getClasseTeste() {
        return this.classeTeste;
    }
}

