/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit;

import br.jus.tst.tstunit.TestUnitException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuracao
implements Serializable {
    private static final long serialVersionUID = 3577294568759890149L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuracao.class);
    private static final String NOME_PADRAO_ARQUIVO_PROPRIEDADES = "testunit.properties";
    private static Configuracao singleton;
    private String nomeArquivoPropriedades = "testunit.properties";
    private transient Properties properties;

    private Configuracao() {
    }

    public static Configuracao getInstance() {
        if (singleton == null) {
            singleton = new Configuracao();
        }
        return singleton;
    }

    public String getNomeArquivoPropriedades() {
        return this.nomeArquivoPropriedades;
    }

    public Configuracao setNomeArquivoPropriedades(String nomeArquivoPropriedades) {
        this.nomeArquivoPropriedades = nomeArquivoPropriedades;
        return this;
    }

    public Configuracao carregar() throws TestUnitException {
        LOGGER.debug("Carregando propriedades a partir do arquivo: {}", (Object)this.nomeArquivoPropriedades);
        Optional<InputStream> propertiesStreamOptional = Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.nomeArquivoPropriedades));
        InputStream propertiesStream = propertiesStreamOptional.orElseThrow(() -> new TestUnitException("Nenhum arquivo " + this.nomeArquivoPropriedades + " encontrado no classpath."));
        this.properties = new Properties();
        try {
            this.properties.load(propertiesStream);
            LOGGER.trace("Propriedades: {}", (Object)this.properties);
        }
        catch (IOException exception) {
            throw new TestUnitException("Erro ao carregar arquivo de propriedades", exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)propertiesStream);
        }
        return this;
    }

    public Optional<Boolean> getPropriedadeBoolean(String key) {
        String value = this.isCarregado() ? this.properties.getProperty(key) : null;
        return StringUtils.isEmpty((CharSequence)value) ? Optional.empty() : Optional.of(BooleanUtils.toBoolean((String)value));
    }

    public Properties getSubPropriedades(String prefixo) {
        Properties subProperties;
        Validate.validState((boolean)this.isCarregado(), (String)"Ainda n\u00e3o foram carregadas as propriedades do arquivo %s", (Object[])new Object[]{this.nomeArquivoPropriedades});
        if (StringUtils.isNotBlank((CharSequence)prefixo)) {
            subProperties = new Properties();
            this.properties.keySet().stream().map(keyObject -> keyObject.toString()).filter(key -> key.startsWith(prefixo)).forEach(key -> subProperties.setProperty(StringUtils.removeStart((String)key, (String)(prefixo + '.')), this.properties.getProperty((String)key)));
        } else {
            subProperties = this.properties;
        }
        return subProperties;
    }

    public boolean isCarregado() {
        return this.properties != null;
    }
}

